/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18nSupport {
    private static final Locale LOCALE = new Locale("en", "US");
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("messages", LOCALE);

    private I18nSupport() {
    }

    public static String getLabel(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public static String getLabel(String key, Object ... values) {
        try {
            return MessageFormat.format(I18nSupport.getLabel(key), values);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }
}

