/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.statement;

import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.base.Strings;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class VariableDeclarationTest {
    private static final String LONG_NAME = Strings.repeat("a", 256);
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"{ String array; }", I18nSupport.getLabel("invalid.reserved.name.identifier", "array")}, {"{ String " + LONG_NAME + "; }", I18nSupport.getLabel("identifier.too.long", LONG_NAME)}, {"{ String str = true; }", I18nSupport.getLabel("illegal.assignment", TypeInfos.BOOLEAN, TypeInfos.STRING)}, {"{ Void var; }", I18nSupport.getLabel("invalid.void.variable")}, {"{ Foo f; }", I18nSupport.getLabel("invalid.unresolved.type", "Foo")}, {"{ Integer i = foo; }", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"{ Integer i; Integer i; }", I18nSupport.getLabel("duplicate.variable", "i")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"{ String str; }"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }

    @DataProvider
    Object[][] validVersionData() {
        return new Object[][]{{"{ Void var; }"}};
    }

    @Test(dataProvider="validVersionData")
    public void test168Versioning(String code) {
        this.tester.setVersion(Version.MIN);
        this.tester.assertSuccess(code);
    }
}

