/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.statement;

import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TryCatchFinallyBlockStatementTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"try {}", new String[]{I18nSupport.getLabel("invalid.try.needs.catch.or.finally")}}, {"try {} catch (foo x) {}", new String[]{I18nSupport.getLabel("invalid.unresolved.type", "foo")}}, {"try {} catch (Integer x) {}", new String[]{I18nSupport.getLabel("invalid.catch.exception", TypeInfos.INTEGER)}}, {"try {} catch (Exception x) {} catch (Exception x) {}", new String[]{I18nSupport.getLabel("invalid.catch.duplicate.exception", TypeInfos.EXCEPTION)}}, {"class MyException extends Exception {} try {} catch (Exception x) {} catch (MyException x) {}", new String[]{I18nSupport.getLabel("invalid.catch.duplicate.exception", "MyException")}}, {"try {} catch (foo x) {} catch (foo x) {}", new String[]{I18nSupport.getLabel("invalid.unresolved.type", "foo"), I18nSupport.getLabel("invalid.unresolved.type", "foo")}}, {"try {} catch (Exception x) { foo f; }", new String[]{I18nSupport.getLabel("invalid.unresolved.type", "foo")}}, {"try { foo x; } finally {} ", new String[]{I18nSupport.getLabel("invalid.unresolved.type", "foo")}}, {"try {} finally { foo x; } ", new String[]{I18nSupport.getLabel("invalid.unresolved.type", "foo")}}, {"try {} catch (Exception) { }", new String[]{I18nSupport.getLabel("unexpected.token", ")")}}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String[] expectedErrors) {
        this.tester.assertFailure(code, expectedErrors);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"class MyException extends Exception {} try {} catch (MyException x) {} catch (Exception x) {}"}, {"try {} finally {}"}, {"try {} catch (Exception x) {}"}, {"try {} catch (System.Exception x) {}"}, {"try {} catch (Exception x) {} finally {}"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }
}

