/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.statement;

import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.StructuredVersion;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class RunAsBlockStatementTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
        this.tester.setNamespace(Namespaces.APEX);
        this.tester.getAccessEvaluator().addValidPackageVersion(Namespaces.APEX, new StructuredVersion(1, 0));
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"System.runAs(1, 0) {}", I18nSupport.getLabel("invalid.runas")}, {"System.runAs(1) {}", I18nSupport.getLabel("invalid.runas")}, {"System.runAs(foo) {}", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"System.runAs(Package.Version.1.0) { Foo x; }", I18nSupport.getLabel("invalid.unresolved.type", "Foo")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"Version v; System.runAs(v) {}"}, {"User u; System.runAs(u) {}"}, {"System.runAs(Package.Version.1.0) {}"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }
}

