/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.statement;

import apex.jorje.data.JadtTester;
import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.exception.SemanticException;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ReturnStatementTest {
    private static final String UNREACHABLE_STATEMENT = I18nSupport.getLabel("unreachable.statement");
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidAnonymousData() {
        return new Object[][]{{"class foo { { return 0; } foo() {} }", I18nSupport.getLabel("invalid.return.from.non.method")}, {"void foo() { return 0; }", I18nSupport.getLabel("invalid.return.void")}, {"Integer foo() { return; }", I18nSupport.getLabel("invalid.return.non.void", TypeInfos.INTEGER)}, {"class foo { foo() { return 0; } }", I18nSupport.getLabel("invalid.constructor.return")}, {"Integer foo() { return 'foo'; }", I18nSupport.getLabel("illegal.conversion", TypeInfos.STRING, TypeInfos.INTEGER)}, {"Integer foo() { if (false) return 1; }", I18nSupport.getLabel("invalid.return.non.void", TypeInfos.INTEGER)}, {"Integer foo() { return foo; }", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"Foo foo() { return null; }", I18nSupport.getLabel("invalid.unresolved.type", "Foo")}};
    }

    @Test(dataProvider="invalidAnonymousData")
    public void testInvalidAnonymous(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] invalidNamedData() {
        return new Object[][]{{"trigger foo on Account (before insert) { return 0; }", I18nSupport.getLabel("invalid.trigger.return")}};
    }

    @Test(dataProvider="invalidNamedData")
    public void testInvalidNamed(String code, String expectedError) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(code, expectedError);
    }

    @Test
    public void testInvalidWithLoc() {
        String code = "Integer foo() { return 1; Integer i; Integer j; }";
        this.tester.setVersion(Version.V200);
        this.tester.assertLocFailure("Integer foo() { return 1; Integer i; Integer j; }", new SemanticException(JadtTester.loc((int)37, (int)9), UNREACHABLE_STATEMENT));
        this.tester.setVersion(Version.V202);
        this.tester.assertLocFailure("Integer foo() { return 1; Integer i; Integer j; }", new SemanticException(JadtTester.loc((int)26, (int)9), UNREACHABLE_STATEMENT));
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"Long foo() { return 0; }"}, {"Long foo() { return 0L; }"}, {"void foo() { return; }"}, {"void foo() { if (true) { return; } Integer i; }"}, {"void foo() { if (true) { } else { return; } Integer i; }"}, {"void foo() { try { return; } catch (Exception x) { } finally { } Integer i; }"}, {"void foo() { try { } catch (Exception x) { return; } finally { } Integer i; }"}, {"while(true) { return; } Integer i;"}, {"for(;;) { return; } Integer i;"}, {"do { return; } while(true); Integer i;"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }

    @DataProvider
    Object[][] unreachableStatementData() {
        return new Object[][]{{"Integer foo() { return 0; Integer i; Integer j; }"}, {"Integer foo() { return 0; Integer i; return 0; Integer j; }"}, {"Integer foo() { if (true) { return 0; } else { return 0; } Integer i; }"}, {"Integer foo() { try { return 0; } finally { } Integer i; }"}, {"Integer foo() { try { return 0; } catch (Exception x) { return 0; } Integer i; }"}, {"Integer foo() { try { return 0; } catch (Exception x) { return 0; } finally { return 0; } Integer i; }"}};
    }

    @Test(dataProvider="unreachableStatementData")
    public void testUnreachableStatementBefore202(String code) {
        this.tester.setVersion(Version.V200);
        this.tester.assertFailure(code, UNREACHABLE_STATEMENT);
    }

    @Test(dataProvider="unreachableStatementData")
    public void testUnreachableStatement202(String code) {
        this.tester.setVersion(Version.V202);
        this.tester.assertFailure(code, UNREACHABLE_STATEMENT);
    }

    @DataProvider
    Object[][] unreachableStatementJavaData() {
        return new Object[][]{{"void method1() { return; Integer i; return; }"}, {"void method2() { if (true) { return; } else { return; } return; Integer i; return;}"}};
    }

    @Test(dataProvider="unreachableStatementJavaData")
    public void testValidVersion(String code) {
        this.tester.setVersion(Version.V200);
        this.tester.assertSuccess(code);
    }

    @Test(dataProvider="unreachableStatementJavaData")
    public void testValidNormal(String code) {
        this.tester.setVersion(Version.V202);
        this.tester.assertFailure(code, UNREACHABLE_STATEMENT);
    }

    @Test
    public void testValidVoidMultipleReturn() {
        this.tester.setVersion(Version.V200);
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccess("public class foo { void doNothing() { return; for (Integer i = 0; i < 4; i ++) { System.debug(i); } } }");
    }
}

