/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.statement;

import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ForLoopStatementTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"for (; 5; );", I18nSupport.getLabel("invalid.condition.type", TypeInfos.INTEGER)}, {"for (foo = 5;; );", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"for (; foo; );", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"for (;; foo);", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"for (;;) { foo; }", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"for (foo;;) { }", I18nSupport.getLabel("unexpected.token", ";")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"for (;;) {}"}, {"for (Integer i = 0, j; i < 17; i++);"}, {"Integer i, j; for (i = 0, j = 0; i < 17; i++);"}};
    }

    @Test(dataProvider="validData")
    public void testValidData(String code) {
        this.tester.assertSuccess(code);
    }
}

