/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.statement;

import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.StructuredVersion;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ExpressionStatementTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
        this.tester.setTrusted(true);
        this.tester.setNamespace(Namespaces.APEX);
        this.tester.getAccessEvaluator().addValidPackageVersion(Namespaces.APEX, new StructuredVersion(1, 0));
    }

    @DataProvider
    Object[][] invalidTopLevel() {
        return new Object[][]{{"true ? 17 : 29;"}, {"~0;"}, {"1 + 1;"}, {"Long l; l instanceof Integer;"}, {"1 < 2;"}, {"Trigger.new;"}, {"Integer[] i; i[0];"}, {"Integer i; i;"}, {"java:java.lang.Integer.MAX_VALUE;"}, {"String.class;"}, {"1729;"}, {"Integer i; (i++);"}, {"[ FIND 'foobar' ];"}, {"[ SELECT x FROM Account ];"}, {"Package.Version.1.0;"}};
    }

    @Test(dataProvider="invalidTopLevel")
    public void testInvalidTopLevelExpression(String statement) {
        this.tester.assertFailure(statement, I18nSupport.getLabel("invalid.expression.statement"));
    }

    @DataProvider
    Object[][] validTopLevel() {
        return new Object[][]{{"Integer i; i = 1729;"}, {"Integer i; ++i;"}, {"Integer i; i++;"}, {"Integer i; --i;"}, {"Integer i; i--;"}, {"System.assert(true);"}, {"java:java.lang.Integer.valueOf(1729);"}, {"new List<String>();"}};
    }

    @Test(dataProvider="validTopLevel")
    public void testValidTopLevelExpression(String statement) {
        this.tester.assertSuccess(statement);
    }
}

