/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.statement;

import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.TestSObjectTypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DmlUpsertStatementTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"upsert 5;", I18nSupport.getLabel("invalid.dml.type", TypeInfos.INTEGER)}, {"upsert foo;", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"User u; upsert u;", I18nSupport.getLabel("dml.operation.not.allowed", DmlOperation.UPSERT.getApexName(), TestSObjectTypeInfos.USER)}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"Account a; upsert a;"}, {"List<Account> aList; upsert aList;"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }
}

