/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.statement;

import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DmlUpdateStatementTest {
    private ValidationTester tester;

    @BeforeTest
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"update 5;", I18nSupport.getLabel("invalid.dml.type", TypeInfos.INTEGER)}, {"update foo;", I18nSupport.getLabel("variable.does.not.exist", "foo")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalidData(String source, String expectedError) {
        this.tester.assertFailure(source, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"Account a; update a;"}, {"List<Account> l; update l;"}};
    }

    @Test(dataProvider="validData")
    public void testValidData(String source) {
        this.tester.assertSuccess(source);
    }
}

