/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.statement;

import apex.jorje.data.JadtTester;
import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.exception.SemanticException;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.exception.CompilationException;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ConstructorPreambleStatementTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"public virtual class Bar { Bar(Integer i) {} class Foo extends Bar { Foo() {} } }", new SemanticException(JadtTester.loc((int)69, (int)3), I18nSupport.getLabel("invalid.default.constructor", "Bar"))}, {"public virtual class Bar { Bar(Integer i) {} class Foo extends Bar { } }", new SemanticException(JadtTester.loc((int)51, (int)3), I18nSupport.getLabel("invalid.default.constructor", "Bar"))}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, CompilationException expectedError) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertLocFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[0][];
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }
}

