/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.modifier;

import apex.jorje.semantic.ast.modifier.rule.Element;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class WebServiceRuleTest
extends ValidationTest {
    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"public class Foo{ webservice Integer foo; }", I18nSupport.getLabel("modifier.requires", new Object[]{I18nSupport.getLabel("modifier.illegal.defining.type.for", ModifierTypeInfos.WEB_SERVICE), Element.FIELD, ModifierTypeInfos.GLOBAL})}, {"global class Foo{ @deprecated webservice Integer foo; }", I18nSupport.getLabel("modifier.cannot.be", new Object[]{ModifierTypeInfos.WEB_SERVICE, Element.FIELD, AnnotationTypeInfos.DEPRECATED})}, {"@deprecated global class Foo{ webservice Integer foo; }", I18nSupport.getLabel("modifier.illegal.defining.type.for", I18nSupport.getLabel("modifier.cannot.be", new Object[]{ModifierTypeInfos.WEB_SERVICE, Element.FIELD, AnnotationTypeInfos.DEPRECATED}))}, {"public class Foo{ static webservice void m(){} }", I18nSupport.getLabel("modifier.requires", new Object[]{I18nSupport.getLabel("modifier.illegal.defining.type.for", ModifierTypeInfos.WEB_SERVICE), Element.METHOD, ModifierTypeInfos.GLOBAL})}, {"global class Foo{ webservice void m(){} }", I18nSupport.getLabel("modifier.requires", new Object[]{ModifierTypeInfos.WEB_SERVICE, Element.METHOD, ModifierTypeInfos.STATIC})}, {"global class Foo{ @deprecated static webservice void m(){} }", I18nSupport.getLabel("modifier.cannot.be", new Object[]{ModifierTypeInfos.WEB_SERVICE, Element.METHOD, AnnotationTypeInfos.DEPRECATED})}, {"@deprecated global class Foo{ static webservice void m(){} }", I18nSupport.getLabel("modifier.illegal.defining.type.for", I18nSupport.getLabel("modifier.cannot.be", new Object[]{ModifierTypeInfos.WEB_SERVICE, Element.METHOD, AnnotationTypeInfos.DEPRECATED}))}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"global class Foo{ webservice Integer foo; }"}, {"global class Foo { webservice static List<String> m() { return null; } }"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }
}

