/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.modifier;

import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import java.util.Arrays;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class VisibleApiVersionTest
extends ValidationTest {
    private static final SourceFile SOURCE = SourceFile.builder().setBody("global class FTestMinApiVersionClass {\n    @VisibleApiVersion(MinApiVersion='176' MaxApiVersion='178')\n    global static integer field1;\n    @VisibleApiVersion(MinApiVersion='176' MaxApiVersion='178')\n    global integer field2;\n    //make sure that classes can access their own fields\n    @VisibleApiVersion(MaxApiVersion='172')\n    private integer field3;\n\n    @VisibleApiVersion(MinApiVersion='176' MaxApiVersion='178')\n    global static integer prop1 {get; set;}\n    @VisibleApiVersion(MinApiVersion='176' MaxApiVersion='178')\n    global integer prop2 {get {return field3;} set {field3 = value;} }\n\n    @VisibleApiVersion(MinApiVersion='176' MaxApiVersion='178')\n    global static void foo() {}\n}\n").setTrusted(true).build();

    @DataProvider
    Object[][] visibleApiVersionData() {
        return new Object[][]{{"FTestMinApiVersionClass.foo();", "foo", "Method"}, {"FTestMinApiVersionClass.prop1 = 7;", "prop1", "Property"}, {"Integer i = FTestMinApiVersionClass.prop1;", "prop1", "Property"}, {"new FTestMinApiVersionClass().prop2 = 7;", "prop2", "Property"}, {"Integer i = new FTestMinApiVersionClass().prop2;", "prop2", "Property"}, {"FTestMinApiVersionClass.field1 = 7;", "field1", "Field"}, {"Integer i = FTestMinApiVersionClass.field1;", "field1", "Field"}, {"new FTestMinApiVersionClass().field2 = 7;", "field2", "Field"}, {"Integer i = new FTestMinApiVersionClass().field2;", "field2", "Field"}};
    }

    @Test(dataProvider="visibleApiVersionData")
    public void testVisibleApiVersion(String referenceSource, String memberName, String type) {
        SourceFile source = SourceFile.builder().setVersion(Version.V176).setBody(String.format("public class Foo { { %s } }", referenceSource)).build();
        this.tester.assertSuccess(SOURCE, source);
    }

    @Test(dataProvider="visibleApiVersionData")
    public void testTrustedVisibleApiVersion(String referenceSource, String memberName, String type) {
        SourceFile source = SourceFile.builder().setVersion(Version.V200).setTrusted(true).setBody(String.format("public class Foo { { %s } }", referenceSource)).build();
        this.tester.assertSuccess(SOURCE, source);
    }

    @Test(dataProvider="visibleApiVersionData")
    public void testLessThanVisibleApiVersion(String referenceSource, String memberName, String type) {
        SourceFile source = SourceFile.builder().setVersion(Version.V174).setBody(String.format("public class Foo { { %s } }", referenceSource)).build();
        String error = I18nSupport.getLabel("not.visible.min.version", type, memberName, "24.0");
        this.tester.assertFailures(Arrays.asList(SOURCE, source), error);
    }

    @Test(dataProvider="visibleApiVersionData")
    public void testGreaterThanVisibleApiVersion(String referenceSource, String memberName, String type) {
        SourceFile source = SourceFile.builder().setVersion(Version.V180).setBody(String.format("public class Foo { { %s } }", referenceSource)).build();
        String error = I18nSupport.getLabel("not.visible.max.version", type, memberName, "25.0");
        this.tester.assertFailures(Arrays.asList(SOURCE, source), error);
    }
}

