/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.modifier;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TransientRuleTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"public class Foo { public transient String bar; }"}, {"public class Foo { public transient String bar {get; set;} }"}, {"public class Foo { void doNothing() { transient String bar; } }"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccess(code);
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"public transient class Foo {}", I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{ModifierTypeInfos.TRANSIENT, UnitType.CLASS})}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(code, expectedError);
    }
}

