/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.modifier;

import apex.jorje.semantic.ast.modifier.rule.Element;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestSetupRuleTest
extends ValidationTest {
    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"@IsTest public class FooTest { @TestSetup void setup(){} }", I18nSupport.getLabel("modifier.requires", new Object[]{AnnotationTypeInfos.TEST_SETUP, Element.METHOD, ModifierTypeInfos.STATIC})}, {"public class FooTest { @TestSetup static void setup(){} }", I18nSupport.getLabel("modifier.requires", new Object[]{I18nSupport.getLabel("modifier.illegal.defining.type.for", AnnotationTypeInfos.TEST_SETUP), Element.METHOD, AnnotationTypeInfos.IS_TEST})}, {"@IsTest public class FooTest { @TestSetup static String setup(){ return 'foo'; } }", I18nSupport.getLabel("test.setup.must.return.void")}, {"@IsTest public class FooTest { @TestSetup static void setup(String param){} }", I18nSupport.getLabel("test.setup.cannot.have.params")}, {"@IsTest(seeAllData='true') public class FooTest { @TestSetup static void setup(){} }", I18nSupport.getLabel("test.setup.cannot.have.defining.type.see.all.data")}, {"@IsTest public class FooTest { @IsTest(seeAllData='true') static void foo(){} @TestSetup static void setup(){} }", I18nSupport.getLabel("test.setup.cannot.have.see.all.data")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"@IsTest public class FooTest { @TestSetup static void setup(){} }"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }
}

