/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.modifier;

import apex.jorje.semantic.ast.modifier.rule.Element;
import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class MethodRuleGroupTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"public class Foo{ global void m(){} }", I18nSupport.getLabel("modifier.requires", new Object[]{I18nSupport.getLabel("modifier.illegal.defining.type.for", ModifierTypeInfos.GLOBAL), Element.METHOD, ModifierTypeInfos.GLOBAL})}, {"global class Foo{ class Bar{} global Bar m(){ return new Bar(); } }", I18nSupport.getLabel("method.does.not.support.return.type", ModifierTypeInfos.GLOBAL, "Foo.Bar")}, {"global class Foo{ class Bar{} global void m(Bar b){} }", I18nSupport.getLabel("method.does.not.support.parameter.type", ModifierTypeInfos.GLOBAL, "Foo.Bar")}, {"global class Foo{ @deprecated global class Bar{} global Bar m(){ return new Bar(); } }", I18nSupport.getLabel("global.deprecate.if.return.deprecated", "Foo.Bar")}, {"global class Foo{ @deprecated global class Bar{} global void m(Bar b){} }", I18nSupport.getLabel("global.deprecate.if.parameter.deprecated", "Foo.Bar")}, {"public class Foo{ virtual foo(){} }", I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{ModifierTypeInfos.VIRTUAL, Element.CONSTRUCTOR})}, {"public class Foo{ override foo(){} }", I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{ModifierTypeInfos.OVERRIDE, Element.CONSTRUCTOR})}, {"public class Foo{ static foo(){} }", I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{ModifierTypeInfos.STATIC, Element.CONSTRUCTOR})}, {"public class Foo{ public void m1(){} class Bar{ static void m() {} } }", I18nSupport.getLabel("modifier.not.in.top.level.type", new Object[]{ModifierTypeInfos.STATIC, Element.METHOD})}, {"public class Bar{ static override String toString(){ return ''; }  }", I18nSupport.getLabel("modifier.cannot.be", new Object[]{ModifierTypeInfos.STATIC, Element.METHOD, ModifierTypeInfos.OVERRIDE})}, {"public class Bar{ final void m(){}  }", I18nSupport.getLabel("modifier.is.by.default", new Object[]{Element.METHOD, ModifierTypeInfos.FINAL})}, {"public class Bar{ transient void m(){}  }", I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{ModifierTypeInfos.TRANSIENT, Element.METHOD})}, {"public class Bar{ with sharing void m(){}  }", I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{ModifierTypeInfos.WITH_SHARING, Element.METHOD})}, {"public class Bar{ without sharing void m(){}  }", I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{ModifierTypeInfos.WITHOUT_SHARING, Element.METHOD})}, {"public class Foo{ public private void method(){} }", I18nSupport.getLabel("declarations.single.scope")}, {"global class Foo{ global public void method(){} }", I18nSupport.getLabel("declarations.single.scope")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"public class Foo{ foo(){} }"}, {"global class Foo{ foo(){} }"}, {"global class Foo{ global foo(){} }"}, {"public class Foo{ private foo(){} }"}, {"public class Foo{ public foo(){} }"}, {"global class Foo{ @deprecated global class Bar{} @deprecated global Bar m(){ return new Bar(); } }"}, {"global class Foo{ @deprecated global class Bar{} @deprecated global void m(Bar b){} }"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccess(code);
    }

    @DataProvider
    Object[][] invalidVersionData() {
        return new Object[][]{{"public class Foo{ public class MyTest { testMethod void test1(){} } }", I18nSupport.getLabel("modifier.not.in.top.level.type", new Object[]{ModifierTypeInfos.TEST_METHOD, Element.METHOD})}};
    }

    @Test(dataProvider="invalidVersionData")
    public void testInvalidVersionData(String code, String expectedError) {
        this.tester.setVersion(Version.MIN);
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] invalidAnonymousData() {
        return new Object[][]{{"protected void m(){}", I18nSupport.getLabel("modifier.illegal.defining.type", new Object[]{ModifierTypeInfos.PROTECTED, UnitType.ANONYMOUS})}, {"virtual void m(){}", I18nSupport.getLabel("modifier.illegal.defining.type", new Object[]{ModifierTypeInfos.VIRTUAL, UnitType.ANONYMOUS})}};
    }

    @Test(dataProvider="invalidAnonymousData")
    public void testInvalidAnonymous(String code, String expectedError) {
        this.tester.setParserType(ParserWrapper.Type.ANONYMOUS);
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validVersionTestData() {
        return new Object[][]{{"public class foo { static testMethod void testFoo() {} }"}};
    }

    @Test(dataProvider="validVersionTestData")
    public void testValidVersionTestMethod(String code) {
        this.tester.setVersion(Version.MIN);
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccess(code);
    }
}

