/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.modifier;

import apex.jorje.semantic.ast.modifier.rule.Element;
import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class LocalsRuleGroupTest {
    private ValidationTester namedTester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.namedTester = new ValidationTester();
        this.namedTester.setParserType(ParserWrapper.Type.NAMED);
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"public class Foo{ void m1(){public integer v1;} }", new String[]{I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{ModifierTypeInfos.PUBLIC, Element.LOCAL})}}, {"public class Foo{ void m1(){public public integer v1;} }", new String[]{I18nSupport.getLabel("duplicate.modifier", ModifierTypeInfos.PUBLIC), I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{ModifierTypeInfos.PUBLIC, Element.LOCAL})}}, {"public class Foo{ void m1(){final final integer v1;} }", new String[]{I18nSupport.getLabel("duplicate.modifier", ModifierTypeInfos.FINAL)}}, {"public class Foo{ void m1(){public integer v1, v2;} }", new String[]{I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{ModifierTypeInfos.PUBLIC, Element.LOCAL}), I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{ModifierTypeInfos.PUBLIC, Element.LOCAL})}}, {"public class Foo{ void m1(){@BadAnnotation integer v1;} }", new String[]{I18nSupport.getLabel("invalid.unresolved.annotation", "BadAnnotation")}}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String[] expectedErrors) {
        this.namedTester.assertFailure(code, expectedErrors);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"public class Foo{ void m1(){integer v1;} }"}, {"public class Foo{ void m1(){integer v1, v2;} }"}, {"public class Foo{ void m1(){final integer v1;} }"}, {"public class Foo{ void m1(){final integer v1, v2;} }"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.namedTester.assertSuccess(code);
    }
}

