/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.modifier;

import apex.jorje.semantic.ast.modifier.rule.Element;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class InvocableActionRuleTest
extends ValidationTest {
    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"public class Foo { @InvocableMethod private static void bar(List<String> lst) {} }", I18nSupport.getLabel("modifier.requires.at.least", new Object[]{AnnotationTypeInfos.INVOCABLE_METHOD, Element.METHOD, ModifierTypeInfos.GLOBAL + ", " + ModifierTypeInfos.PUBLIC})}, {"public class Foo { @InvocableMethod public void bar(List<String> lst){} }", I18nSupport.getLabel("modifier.requires", new Object[]{AnnotationTypeInfos.INVOCABLE_METHOD, Element.METHOD, ModifierTypeInfos.STATIC})}, {"public class Foo { @InvocableMethod public void bar(List<String> lst){} }", I18nSupport.getLabel("modifier.requires", new Object[]{AnnotationTypeInfos.INVOCABLE_METHOD, Element.METHOD, ModifierTypeInfos.STATIC})}, {"public class Foo { @InvocableMethod public static void bar(String p1, String p2) {} }", I18nSupport.getLabel("invocable.method.single.param")}, {"@IsTest public class Foo { @IsTest @InvocableMethod public static void bar() {} }", I18nSupport.getLabel("invocable.method.only")}, {"public class Foo { @InvocableMethod public static void bar1() {} @InvocableMethod public static void bar2() {} }", I18nSupport.getLabel("invalid.multiple.methods.with.modifier", AnnotationTypeInfos.INVOCABLE_METHOD)}, {"trigger FooTrigger on Account (before insert) { @InvocableMethod public static void bar() {} }", I18nSupport.getLabel("invocable.method.class.only")}, {"global class Foo { @InvocableMethod global static void bar(Integer i) {} }", I18nSupport.getLabel("invocable.method.accepts.list.types", TypeInfos.INTEGER)}, {"public class Foo { private class InnerFoo { @InvocableVariable public String bar; } }", I18nSupport.getLabel("modifier.cannot.be", new Object[]{I18nSupport.getLabel("modifier.illegal.defining.type.for", AnnotationTypeInfos.INVOCABLE_VARIABLE), Element.FIELD, ModifierTypeInfos.PRIVATE})}, {"public class Foo { @InvocableVariable private String bar; }", I18nSupport.getLabel("modifier.requires.at.least", new Object[]{AnnotationTypeInfos.INVOCABLE_VARIABLE, Element.FIELD, ModifierTypeInfos.GLOBAL + ", " + ModifierTypeInfos.PUBLIC})}, {"public class Foo { @InvocableVariable public static String bar; }", I18nSupport.getLabel("modifier.cannot.be", new Object[]{AnnotationTypeInfos.INVOCABLE_VARIABLE, Element.FIELD, ModifierTypeInfos.STATIC})}, {"public class Foo { @InvocableVariable public final String bar; }", I18nSupport.getLabel("modifier.cannot.be", new Object[]{AnnotationTypeInfos.INVOCABLE_VARIABLE, Element.FIELD, ModifierTypeInfos.FINAL})}, {"public class Foo{ @InvocableVariable public integer prop {get; set;}}", I18nSupport.getLabel("modifier.is.not.allowed", "InvocableVariable", "properties")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"global class Foo { @InvocableMethod global static void bar(List<Integer> lst) {} }"}, {"public class Foo { @InvocableMethod public static void bar() {} }"}, {"public class Foo { @InvocableMethod(label='') public static void bar() {} }"}, {"public class Foo { @InvocableVariable public String bar; }"}, {"global class Foo { @InvocableMethod global static void bar(List<FooBar> fb) {} public class FooBar{ @InvocableVariable public String fooFoo; } }"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }

    @DataProvider
    Object[][] validMultiFileData() {
        return new Object[][]{{ImmutableList.of("global class Foo { @InvocableMethod global static void bar(List<Bar> b) {} }", "global class Bar { @InvocableVariable public String fooFoo; }")}};
    }

    @Test(dataProvider="validMultiFileData")
    public void testValidMultiFile(List<String> scripts) {
        this.tester.assertSuccess(scripts);
    }

    @DataProvider
    Object[][] invalidMultiFileData() {
        return new Object[][]{{ImmutableList.of("global class Foo { @InvocableMethod global static void fooMethod(List<Bar> b) {} }", "global class Bar { public String fooFoo; }")}};
    }

    @Test(dataProvider="invalidMultiFileData")
    public void testInvalidMultiFile(List<String> scripts) {
        this.tester.assertFailure(scripts, I18nSupport.getLabel("method.does.not.support.parameter.type", AnnotationTypeInfos.INVOCABLE_METHOD, "List<Bar>"));
    }
}

