/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.modifier;

import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.StandardAnnotationTypeInfo;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class InternalRuleTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
        this.tester.setParserType(ParserWrapper.Type.NAMED);
    }

    @DataProvider
    Object[][] internalAnnotations() {
        return new Object[][]{{"@UseConnectSerializer public class Bar{ }", AnnotationTypeInfos.USE_CONNECT_SERIALIZER}, {"@UseConnectDeserializer public class Bar{ }", AnnotationTypeInfos.USE_CONNECT_DESERIALIZER}, {"public class Bar{ @VisibleApiVersion void m(){}  }", AnnotationTypeInfos.VISIBLE_API_VERSION}, {"@Batchable(messageSetName='foo') public class Foo { }", AnnotationTypeInfos.BATCHABLE}, {"@SfdcOnly public class Foo { }", AnnotationTypeInfos.SFDC_ONLY}, {"@PermGuard('perm') public class Foo { }", AnnotationTypeInfos.PERM_GUARD}, {"@ApiVersion('160') public class Foo { }", AnnotationTypeInfos.API_VERSION}, {"@HiddenFromDoc public class Foo { }", AnnotationTypeInfos.HIDDEN_FROM_DOC}};
    }

    @Test(dataProvider="internalAnnotations")
    public void testSanity(String code, StandardAnnotationTypeInfo type) {
        this.tester.getAccessEvaluator().allowPermGuard(Namespaces.EMPTY, "perm");
        this.tester.setTrusted(true);
        this.tester.assertSuccess(code);
    }

    @Test(dataProvider="internalAnnotations")
    public void testInvalidInternal(String code, StandardAnnotationTypeInfo type) {
        this.tester.assertFailure(code, I18nSupport.getLabel("modifier.is.internal", type));
    }

    @DataProvider
    Object[][] invalidAnnotationsData() {
        return new Object[][]{{"@ApiVersion('foo') public class Foo { }", I18nSupport.getLabel("annotation.property.invalid.value", "value", "Integer")}, {"@ApiVersion('161') public class Foo { }", I18nSupport.getLabel("annotation.property.invalid.api.version", "value", "ApiVersion", 161)}};
    }

    @Test(dataProvider="invalidAnnotationsData")
    public void testInvalidParameter(String code, String message) {
        this.tester.setTrusted(true);
        this.tester.assertFailure(code, message);
    }
}

