/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.modifier;

import apex.jorje.semantic.ast.modifier.rule.Element;
import apex.jorje.semantic.compiler.sfdc.PlaceholderOrgPerm;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FutureRuleTest
extends ValidationTest {
    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"public class Foo { @future void m() {} }", I18nSupport.getLabel("modifier.requires", new Object[]{AnnotationTypeInfos.FUTURE, Element.METHOD, ModifierTypeInfos.STATIC})}, {"public class Foo { @future static String m() { return 'foo'; } }", I18nSupport.getLabel("method.does.not.support.return.type", AnnotationTypeInfos.FUTURE, TypeInfos.STRING)}, {"public class Foo { @future static void m(Object o) {} }", I18nSupport.getLabel("method.does.not.support.parameter.type", AnnotationTypeInfos.FUTURE, TypeInfos.OBJECT)}, {"public class Foo { @future(delay='-1') static void m() {} }", I18nSupport.getLabel("annotation.property.greater.than.or.equal", "delay", AnnotationTypeInfos.FUTURE, 0, -1)}, {"public class Foo { @future(delay='901') static void m() {} }", I18nSupport.getLabel("annotation.property.less.than.or.equal", "delay", AnnotationTypeInfos.FUTURE, 900, 901)}, {"public class Foo { @future(limits='foobar') static void m() {} }", I18nSupport.getLabel("annotation.property.bad.string.value", "limits", AnnotationTypeInfos.FUTURE, "foobar")}, {"public class Foo{ @future Integer num; }", I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{AnnotationTypeInfos.FUTURE, Element.FIELD})}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.getAccessEvaluator().addPermission(PlaceholderOrgPerm.ENHANCED_FUTURES);
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] invalidPermData() {
        return new Object[][]{{"public class Foo { @future(limits='2xHeap') static void m() {} }", I18nSupport.getLabel("annotation.property.not.supported", "limits", AnnotationTypeInfos.FUTURE)}, {"public class Foo { @future(delay='5') static void m() {} }", I18nSupport.getLabel("annotation.property.not.supported", "delay", AnnotationTypeInfos.FUTURE)}};
    }

    @Test(dataProvider="invalidPermData")
    public void testInvalidPerm(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @Test
    public void testPermHeap501Mb() {
        this.tester.getAccessEvaluator().addPermission(PlaceholderOrgPerm.ENHANCED_FUTURES);
        this.tester.assertFailure("public class Foo { @future(limits='HEAP501MB') static void m() {} }", I18nSupport.getLabel("annotation.property.invalid.perm.value", "limits", AnnotationTypeInfos.FUTURE, "HEAP501MB"));
        this.tester.getAccessEvaluator().addPermission(PlaceholderOrgPerm.HEAP_LIMIT_501MB);
        this.tester.assertSuccess("public class Foo { @future(limits='HEAP501MB') static void m() {} }");
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"public class Foo { @future static void m(String str) {} }"}, {"public class Foo { @future(delay='5' limits='2xHeap') static void m(String str) {} }"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.getAccessEvaluator().addPermission(PlaceholderOrgPerm.ENHANCED_FUTURES);
        this.tester.assertSuccess(code);
    }
}

