/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.modifier;

import apex.jorje.semantic.ast.modifier.rule.Element;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DeprecatedRuleTest
extends ValidationTest {
    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"@deprecated global class Foo { static webservice void m() {} }", I18nSupport.getLabel("modifier.illegal.defining.type.for", I18nSupport.getLabel("modifier.cannot.be", new Object[]{ModifierTypeInfos.WEB_SERVICE, Element.METHOD, AnnotationTypeInfos.DEPRECATED}))}, {"global class Foo { @deprecated private static String m() { return 'foo'; } }", I18nSupport.getLabel("modifier.requires", new Object[]{AnnotationTypeInfos.DEPRECATED, Element.METHOD, ModifierTypeInfos.GLOBAL})}, {"global abstract class Foo { @deprecated abstract global void m(Object o); }", I18nSupport.getLabel("modifier.cannot.be", new Object[]{ModifierTypeInfos.ABSTRACT, Element.METHOD, AnnotationTypeInfos.DEPRECATED})}, {"global class Foo { @deprecated static webservice void m(String s) {} }", I18nSupport.getLabel("modifier.cannot.be", new Object[]{ModifierTypeInfos.WEB_SERVICE, Element.METHOD, AnnotationTypeInfos.DEPRECATED})}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"@deprecated global class Foo { @deprecated global static void m(String str) {} }"}, {"global class Foo { public void m(String str) {} }"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }
}

