/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.modifier;

import apex.jorje.semantic.ast.modifier.rule.Element;
import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ClassRuleGroupTest
extends ValidationTest {
    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"public class Foo{ global class Bar{} }", I18nSupport.getLabel("modifier.requires", new Object[]{I18nSupport.getLabel("enclosing.type.for", new Object[]{ModifierTypeInfos.GLOBAL, Element.CLASS}), Element.CLASS, ModifierTypeInfos.GLOBAL})}, {"public class Foo{ global interface Bar{} }", I18nSupport.getLabel("modifier.requires", new Object[]{I18nSupport.getLabel("enclosing.type.for", new Object[]{ModifierTypeInfos.GLOBAL, Element.INTERFACE}), Element.CLASS, ModifierTypeInfos.GLOBAL})}, {"public class Foo{ global enum Bar{} }", I18nSupport.getLabel("modifier.requires", new Object[]{I18nSupport.getLabel("enclosing.type.for", new Object[]{ModifierTypeInfos.GLOBAL, Element.ENUM}), Element.CLASS, ModifierTypeInfos.GLOBAL})}, {"public private class Foo{ public void method(){} }", I18nSupport.getLabel("declarations.single.scope")}, {"class Foo { }", I18nSupport.getLabel("toplevel.must.be.public.or.global")}, {"interface Foo { }", I18nSupport.getLabel("toplevel.must.be.public.or.global")}, {"enum Foo { }", I18nSupport.getLabel("toplevel.must.be.public.or.global")}, {"public final class Foo{ Integer num; }", I18nSupport.getLabel("modifier.is.by.default", new Object[]{Element.CLASS, ModifierTypeInfos.FINAL})}, {"public abstract virtual class Foo{ }", I18nSupport.getLabel("modifier.is.by.default", ModifierTypeInfos.ABSTRACT, ModifierTypeInfos.VIRTUAL)}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"global class Foo{ global Integer num; }"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }

    @DataProvider
    Object[][] invalidAnonymousData() {
        return new Object[][]{{"public virtual class Foo{}", I18nSupport.getLabel("modifier.is.by.default", new Object[]{UnitType.CLASS, ModifierTypeInfos.VIRTUAL})}, {"global class foo{}", I18nSupport.getLabel("modifier.requires", new Object[]{I18nSupport.getLabel("enclosing.type.for", new Object[]{ModifierTypeInfos.GLOBAL, Element.CLASS}), Element.CLASS, ModifierTypeInfos.GLOBAL})}};
    }

    @Test(dataProvider="invalidAnonymousData")
    public void testInvalidAnonymous(String code, String expectedError) {
        this.tester.setParserType(ParserWrapper.Type.ANONYMOUS);
        this.tester.assertFailure(code, expectedError);
    }
}

