/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.modifier;

import apex.jorje.semantic.ast.modifier.rule.Element;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.semantic.tester.TestVfTypeInfos;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AuraEnabledRuleTest
extends ValidationTest {
    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"public class Foo { @AuraEnabled private String str; }", I18nSupport.getLabel("modifier.requires.at.least", new Object[]{AnnotationTypeInfos.AURA_ENABLED, Element.FIELD, ModifierTypeInfos.GLOBAL + ", " + ModifierTypeInfos.PUBLIC})}, {"public class Foo { @AuraEnabled public static String str; }", I18nSupport.getLabel("modifier.cannot.be", new Object[]{AnnotationTypeInfos.AURA_ENABLED, Element.FIELD, ModifierTypeInfos.STATIC})}, {"public class Foo { @AuraEnabled public Set<String> str; }", I18nSupport.getLabel("field.does.not.support.type", AnnotationTypeInfos.AURA_ENABLED, "Set<String>")}, {"public class Foo { @AuraEnabled Foo() {} }", I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{AnnotationTypeInfos.AURA_ENABLED, Element.CONSTRUCTOR})}, {"public class Foo { @AuraEnabled public static String foo; }", I18nSupport.getLabel("modifier.cannot.be", new Object[]{AnnotationTypeInfos.AURA_ENABLED, Element.FIELD, ModifierTypeInfos.STATIC})}, {"public class Foo { @AuraEnabled String getM() { return 'ab'; } }", I18nSupport.getLabel("modifier.requires.at.least", new Object[]{AnnotationTypeInfos.AURA_ENABLED, Element.METHOD, ModifierTypeInfos.GLOBAL + ", " + ModifierTypeInfos.PUBLIC})}, {"public class Foo { @AuraEnabled public Component.Apex.Page getM() { return null; } }", I18nSupport.getLabel("method.does.not.support.return.type", AnnotationTypeInfos.AURA_ENABLED, TestVfTypeInfos.APEX_PAGE)}, {"public class Foo { @AuraEnabled public static String m(Component.Apex.Page o) { return 'foo'; } }", I18nSupport.getLabel("method.does.not.support.parameter.type", AnnotationTypeInfos.AURA_ENABLED, TestVfTypeInfos.APEX_PAGE)}, {"public class Foo { @AuraEnabled public String getM(String s) { return 'ab'; } }", I18nSupport.getLabel("non.static.aura.method.cannot.have.params")}, {"public class Foo { @AuraEnabled public String m() { return 'ab'; } }", I18nSupport.getLabel("non.static.aura.method.must.begin.with.get")}, {"public class Foo { @AuraEnabled public String m; @AuraEnabled public String getM() { return 'ab'; } }", I18nSupport.getLabel("aura.duplicate.method.field", "M")}, {"public class Foo { @AuraEnabled public String getM() { return 'ab'; } @AuraEnabled public String m; }", I18nSupport.getLabel("aura.duplicate.method.field", "M")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"public class Foo { @AuraEnabled public String foo; }"}, {"public class Foo { @AuraEnabled public String getStr() { return 'ab'; } }"}, {"public class Foo { @AuraEnabled public Integer getStr() { return 0; } }"}, {"public class Foo { class Bar{} @AuraEnabled public Bar getBar() { return new Bar(); } }"}, {"public class Foo { @AuraEnabled public Map<String,Account> getMap() { return new Map<String,Account>(); } }"}, {"public class Foo { @AuraEnabled public List<Double> getDouble() { return new List<Double>(); } }"}, {"public class Foo { @AuraEnabled public static String method(Double d) { return 'ab'; } }"}, {"public class Foo { @AuraEnabled public String getM() { return 'ab'; } }"}, {"public class Foo { String m; @AuraEnabled public String getM() { return 'ab'; } }"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }
}

