/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.modifier;

import apex.jorje.semantic.ast.modifier.rule.Element;
import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AbstractRuleTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"public class Foo{ abstract void m(); }", I18nSupport.getLabel("modifier.requires", new Object[]{I18nSupport.getLabel("modifier.illegal.defining.type.for", ModifierTypeInfos.ABSTRACT), Element.METHOD, ModifierTypeInfos.ABSTRACT})}, {"public abstract class Foo{ abstract virtual void m(); }", I18nSupport.getLabel("modifier.is.by.default", ModifierTypeInfos.ABSTRACT, ModifierTypeInfos.VIRTUAL)}, {"global abstract class Foo{ abstract void m(); }", I18nSupport.getLabel("modifier.requires", new Object[]{I18nSupport.getLabel("defining.type.requires", ModifierTypeInfos.GLOBAL, ModifierTypeInfos.ABSTRACT), Element.METHOD, ModifierTypeInfos.GLOBAL})}, {"public abstract class Foo{ @deprecated abstract void m(); }", I18nSupport.getLabel("modifier.cannot.be", new Object[]{ModifierTypeInfos.ABSTRACT, Element.METHOD, AnnotationTypeInfos.DEPRECATED})}, {"public abstract class Foo{ public abstract foo(); }", I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{ModifierTypeInfos.ABSTRACT, Element.CONSTRUCTOR})}, {"public abstract class Foo{ static abstract void m1();  }", I18nSupport.getLabel("modifier.cannot.be", new Object[]{ModifierTypeInfos.STATIC, Element.METHOD, ModifierTypeInfos.ABSTRACT})}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"public abstract class Foo{ foo(){} }"}, {"public abstract class Foo{ abstract void m(); }"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccess(code);
    }
}

