/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.member;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class PropertyTest
extends ValidationTest {
    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"public class Foo {  Integer i; Integer i { get; } }", I18nSupport.getLabel("duplicate.field", "i")}, {"public class Foo { integer prop { global get; } }", I18nSupport.getLabel("illegal.accessor.on.property", "global", "private")}, {"public class Foo { integer prop { global set; } }", I18nSupport.getLabel("illegal.accessor.on.property", "global", "private")}, {"public class Foo { Integer double { get; } }", I18nSupport.getLabel("invalid.reserved.name.identifier", "double")}, {"public class Foo { void foo { get; set; } }", I18nSupport.getLabel("invalid.void.property")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] invalidSetterOnDefaultPropertyV154Data() {
        return new Object[][]{{new String[]{"public class Foo { integer i {get;} { i = 5; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.i")}, Version.V156}, {new String[]{"public class Foo { integer i; }", "public class Bar { { Foo foo = new Foo(); foo.i = 5; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.i")}, Version.V154}};
    }

    @Test
    public void testValidSetterOnDefaultPropertyV154() {
        this.tester.setVersion(Version.V154);
        this.tester.assertSuccess("public class Foo { integer i {get;} { i = 5; } }");
    }

    @Test(dataProvider="invalidSetterOnDefaultPropertyV154Data")
    public void testInvalidSetterOnDefaultPropertyV154(String[] sources, String[] errors, Version version) {
        this.tester.setVersion(version);
        this.tester.assertFailure(sources, errors);
    }

    @DataProvider
    Object[][] validPrivateSetterOnPublicPropertyData() {
        return new Object[][]{{new String[]{"public class Foo { public static Integer p { get; }} ", "public class Bar { { Foo.p = 1; }} "}}, {new String[]{"public class Foo { public static Integer p { get; private set; }} ", "public class Bar { { Foo.p = 1; }} "}}, {new String[]{"public class Foo { public static Integer p { get; protected set; }} ", "public class Bar { { Foo.p = 1; }} "}}, {new String[]{"global class Foo { global static Integer p { get; }} ", "public class Bar { { Foo.p = 1; }} "}}, {new String[]{"global class Foo { global static Integer p { get; private set; }} ", "public class Bar { { Foo.p = 1; }} "}}, {new String[]{"global class Foo { global static Integer p { get; protected set; }} ", "public class Bar { { Foo.p = 1; }} "}}, {new String[]{"public class Foo { public static Integer p { set; }} ", "public class Bar { { Foo.p = 1; }} "}}};
    }

    @Test(dataProvider="validPrivateSetterOnPublicPropertyData")
    public void testValidPrivateSetterOnPublicProperty(String[] sources) {
        this.tester.assertSuccess(sources);
    }

    @DataProvider
    Object[][] invalidPrivateSetterOnPublicPropertyData() {
        return new Object[][]{{new String[]{"public class Foo { public static Integer p { private get; private set; }} ", "public class Bar { { Foo.p = 1; }} "}, I18nSupport.getLabel("variable.not.visible", "Foo.p")}, {new String[]{"public class Foo { public static Integer p { protected get; private set; }} ", "public class Bar { { Foo.p = 1; }} "}, I18nSupport.getLabel("variable.not.visible", "Foo.p")}};
    }

    @Test(dataProvider="invalidPrivateSetterOnPublicPropertyData")
    public void testInvalidPrivateSetterOnPublicProperty(String[] source, String error) {
        this.tester.assertFailure(source, error);
    }

    @DataProvider
    Object[][] validTriggerPropertyData() {
        return new Object[][]{{"trigger FooTrigger on Account (before insert) { public Integer i {get {return i;} public set {i = value;}}}"}, {"trigger FooTrigger on Account (before insert) { public Integer i {get; set;}} "}, {"trigger FooTrigger on Account (before insert) { public Integer i {public get; public set;}} "}};
    }

    @Test(dataProvider="validTriggerPropertyData")
    public void testValidTriggerPropertyData(String sources) {
        this.tester.assertSuccess(sources);
    }

    @Test
    public void testValidVoid() {
        this.tester.setVersion(Version.V186);
        this.tester.assertSuccess("public class Foo { void i {get { } set { i = value; } } }");
        this.tester.assertSuccess("public class Foo { void i {get; set;} }");
    }

    @Test
    public void testInvalidVoidAssignments() {
        this.tester.setVersion(Version.V186);
        this.tester.assertFailure("public class Foo { void i {get { } set { i = 5; } } }", I18nSupport.getLabel("illegal.assignment", TypeInfos.INTEGER, TypeInfos.VOID));
        this.tester.assertFailure("public class Foo { void i {get { } set { i = value; } } { i = 5; } }", I18nSupport.getLabel("illegal.assignment", TypeInfos.INTEGER, TypeInfos.VOID));
    }
}

