/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.member;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.tester.TestConstants;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableListMultimap;
import java.util.Arrays;
import java.util.List;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class PostTypeResolveVisitorTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"interface Foo { void foo(); } class BarOne implements Foo { }", I18nSupport.getLabel("interface.implementation.missing.method", "BarOne", "void Foo.foo()")}, {"interface Foo { String foo(); } class BarOne implements Foo { integer foo(); }", I18nSupport.getLabel("interface.implementation.missing.method", "BarOne", "String Foo.foo()")}, {"interface Foo { void foo(); } class BarOne implements Foo { private void foo() {} }", I18nSupport.getLabel("interface.implementation.method.not.visible", "BarOne", "void Foo.foo()", "Foo")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] invalidComplexData() {
        return new Object[][]{{Arrays.asList("global interface Foo { void foo(); }", "global class BarOne implements Foo { @deprecated global void foo() {} }"), I18nSupport.getLabel("interface.implementation.method.deprecated", "void Foo.foo()")}};
    }

    @Test(dataProvider="invalidComplexData")
    public void testComplexInvalid(List<String> code, String expectedError) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] invalidNamespaceData() {
        return new Object[][]{{new String[]{"global interface I2 extends I1 { void foo(); }", "global interface I1 { void bar(); }"}, "public class BarOne implements NamespaceA.I2 { public void foo() {}}", I18nSupport.getLabel("interface.implementation.missing.method", "NamespaceB.BarOne", "void NamespaceA.I1.bar()")}};
    }

    @Test(dataProvider="invalidNamespaceData")
    public void testInvalidNamespaceData(String[] sourcesInNamespaceA, String sourcesInNamespaceB, String error) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailures(((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)ImmutableListMultimap.builder().putAll((Object)TestConstants.NAMESPACE_A, sourcesInNamespaceA)).put(TestConstants.NAMESPACE_B, sourcesInNamespaceB)).build(), error);
    }

    @DataProvider
    Object[][] validNamespaceData() {
        return new Object[][]{{new String[]{"global interface I2 extends I1 { void foo(); }", "public interface I1 { void bar(); }"}, "public class BarOne implements NamespaceA.I2 { public void foo() {}}"}};
    }

    @Test(dataProvider="validNamespaceData")
    public void testValidNamespaceData(String[] sourcesInNamespaceA, String sourcesInNamespaceB) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccesses(((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)ImmutableListMultimap.builder().putAll((Object)TestConstants.NAMESPACE_A, sourcesInNamespaceA)).put(TestConstants.NAMESPACE_B, sourcesInNamespaceB)).build());
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"interface Foo { void foo(); } interface Bar { void foo(); } class BarOne implements Foo { public void foo() {} } class BarTwo extends BarOne implements Bar { }"}, {"interface Foo { void foo(); } abstract class BarOne implements Foo { private void foo() {} } "}, {"interface Foo { void foo(); } abstract class BarOne implements Foo { } "}, {"interface Foo { void foo(); } abstract class BarOne implements Foo { Integer foo() { return 1; } } "}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }
}

