/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.member;

import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ParameterTest
extends ValidationTest {
    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"public class Foo { void m(NonExistentType t) { } }", I18nSupport.getLabel("invalid.unresolved.type", "NonExistentType")}, {"public class Foo { void m(void t) { } }", I18nSupport.getLabel("invalid.void.parameter")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expected) {
        this.tester.assertFailure(code, expected);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{ImmutableList.of("public class OuterClass { @TestVisible private class InnerClass { } }", "@isTest public class Test { public void foo(OuterClass.InnerClass ic) { } }")}};
    }

    @Test(dataProvider="validData")
    public void testValid(List<String> code) {
        this.tester.assertSuccess(code);
    }

    @DataProvider
    Object[][] validVersionData() {
        return new Object[][]{{ImmutableList.of("public class Foo { void m(void t) { } }"), Version.V160}};
    }

    @Test(dataProvider="validVersionData")
    public void testValidVersion(List<String> code, Version version) {
        this.tester.setVersion(version);
        this.tester.assertSuccess(code);
    }
}

