/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TernaryExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"String s = 'a' ? 'b' : 'c';", I18nSupport.getLabel("invalid.condition.type", TypeInfos.STRING)}, {"String s = 'a' == 'a' ? 'b' : 3.14;", I18nSupport.getLabel("incompatible.ternary.expression.types", TypeInfos.DECIMAL, TypeInfos.STRING)}, {"String s = 1 == 1 ? 780000L : 'b';", I18nSupport.getLabel("incompatible.ternary.expression.types", TypeInfos.STRING, TypeInfos.LONG)}, {"String s = foo ? 'a' : 'b';", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"String s = true ? foo : 'b';", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"String s = true ? 'a' : foo;", I18nSupport.getLabel("variable.does.not.exist", "foo")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"Integer i = (2 > 1) ? 2 : 1;"}, {"Double d = (2.0d > 2.2d) ? 1.1d+1 : 3.1d;"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }
}

