/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.tester.TestConstants;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableListMultimap;
import java.util.Arrays;
import java.util.List;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SuperExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
        this.tester.setParserType(ParserWrapper.Type.NAMED);
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"public virtual class Bar { public class Foo extends Bar { { super(); } } }", I18nSupport.getLabel("invalid.super.call")}, {"public virtual class Bar { public class Foo extends Bar { void Bar() { super(); } } }", I18nSupport.getLabel("invalid.super.call")}, {"public virtual class Bar { public class Foo extends Bar { Foo() { { super(); } } } }", I18nSupport.getLabel("invalid.super.call")}, {"public virtual class Bar { public class Foo extends Bar { Foo() { Integer i; super(); } } }", I18nSupport.getLabel("invalid.super.call")}, {"public virtual class Bar { public class Foo extends Bar { Foo() { Foo i = super(); } } }", I18nSupport.getLabel("invalid.super.call")}, {"public class Foo { Integer i; static { super.i = 5; } }", I18nSupport.getLabel("invalid.super.static.context")}, {"public class Foo { Foo() { super(); } }", I18nSupport.getLabel("no.super.type", "Foo")}, {"public virtual class Bar { Bar() {} Bar(Integer i) {} public class Foo extends Bar { Integer i; Foo() { super(i); } } }", I18nSupport.getLabel("illegal.instance.variable.reference.in.constructor", "i")}, {"public virtual class Bar { Bar() {} Bar(Integer i) {} public class Foo extends Bar { Integer i; Foo() { super(++i); } } }", I18nSupport.getLabel("illegal.instance.variable.reference.in.constructor", "i")}, {"public virtual class Bar { Bar() {} Bar(Integer i) {} public class Foo extends Bar { Foo() { super(Bar()); } Integer Bar() { return 0; } } }", I18nSupport.getLabel("illegal.instance.method.reference.in.constructor", "Integer Bar.Foo.Bar()")}, {"public virtual class Bar { Bar() {} Bar(Integer i) {} public class Foo extends Bar { Foo() { super(this.Bar()); } Integer Bar() { return 0; } } }", I18nSupport.getLabel("illegal.instance.variable.reference.in.constructor", "this")}, {"public virtual class Bar { Bar() {} Bar(Integer i) {} public class Foo extends Bar { Foo() { super(super.Bar()); } } Integer Bar() { return 0; } }", I18nSupport.getLabel("illegal.instance.variable.reference.in.constructor", "super")}, {"public virtual class Bar { Bar instance; Bar() {} Bar(Bar i) {} public class Foo extends Bar { Foo() { super(instance.instance); } } }", I18nSupport.getLabel("illegal.instance.variable.reference.in.constructor", "instance")}, {"public virtual class Bar { Bar() {} Bar(Integer i) {} class Foo extends Bar { Integer i; Foo() { super(i = 1); } } } ", I18nSupport.getLabel("illegal.instance.variable.reference.in.constructor", "i")}, {"public virtual class Bar { Bar() {} Bar(Integer i) {} class Foo extends Bar { Integer i; Foo() { super(+(i = 1)); } } }", I18nSupport.getLabel("illegal.instance.variable.reference.in.constructor", "i")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] invalidVisibilityData() {
        return new Object[][]{{Arrays.asList("public virtual class Bar { public Bar() {} private Bar(Integer i) {} }", "public class Foo extends Bar { Foo() { super(1); } }"), I18nSupport.getLabel("method.not.visible", "void Bar.<init>(Integer)")}, {Arrays.asList("public virtual class Bar { public Bar() {} public Bar(Hidden h) {} private class Hidden {} }", "public class Foo extends Bar { Foo() { super(null); } }"), I18nSupport.getLabel("method.parameter.type.not.visible", "Bar.Hidden", "void Bar.<init>(Bar.Hidden)")}};
    }

    @Test(dataProvider="invalidVisibilityData")
    public void testInvalidVisibility(List<String> codes, String expectedError) {
        this.tester.assertFailure(codes, expectedError);
    }

    @Test
    public void testInvisibleSuperType() {
        this.tester.assertFailures(((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)ImmutableListMultimap.builder().put(TestConstants.NAMESPACE_A, "public class Foo extends Bar { public Foo() { } }")).put(TestConstants.NAMESPACE_B, "public virtual class Bar { public Bar(Integer i) {} }")).build(), I18nSupport.getLabel("invalid.unresolved.type", "Bar"));
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"public virtual class Bar { class Foo extends Bar { Foo() { super(); } } }"}, {"public virtual class Bar { class Foo extends Bar { { this.i = 5; } } Integer i; }"}, {"public virtual class Bar { class Foo extends Bar { { super.Bar(); } } void Bar() {} }"}, {"public virtual class Bar { Bar() {} Bar(Integer i) {} public class Foo extends Bar { Integer i; Foo(Integer i) { super(i); } } }"}, {"public virtual class Bar { Bar() {} Bar(Integer i) {} public class Foo extends Bar { Integer i; Foo() { super(new Foo().i); } } }"}, {"public virtual class Bar { Bar() {} Bar(Integer i) {} public class Foo extends Bar { Foo() { super(new Foo().Bar()); } Integer Bar() { return 0; } } }"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }
}

