/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.TestVfTypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class PrefixExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"Boolean b = !'ab';", I18nSupport.getLabel("invalid.boolean.prefix.operand", "!")}, {"Boolean b = !null;", I18nSupport.getLabel("invalid.boolean.prefix.operand", "!")}, {"Integer i= -'abc';", I18nSupport.getLabel("invalid.negate.prefix.operand")}, {"Long l = ~'ab';", I18nSupport.getLabel("invalid.type.bitwise.negate", TypeInfos.STRING)}, {"Double d = ~2.0d;", I18nSupport.getLabel("invalid.type.bitwise.negate", TypeInfos.DOUBLE)}, {"String s; ++s;", I18nSupport.getLabel("invalid.numeric.prefix.increment", TypeInfos.STRING)}, {"Boolean b; --b;", I18nSupport.getLabel("invalid.numeric.prefix.decrement", TypeInfos.BOOLEAN)}, {"Long l = (Long) true;", I18nSupport.getLabel("incompatible.cast.types", TypeInfos.BOOLEAN, TypeInfos.LONG)}, {"Double d = (Double) '3.14159';", I18nSupport.getLabel("incompatible.cast.types", TypeInfos.STRING, TypeInfos.DOUBLE)}, {"String s = (foo) 'bar';", I18nSupport.getLabel("invalid.unresolved.type", "foo")}, {"++foo;", I18nSupport.getLabel("variable.does.not.exist", "foo")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] invalidClassData() {
        return new Object[][]{{" public class Foo { Component.Apex.Page p; Object o = (Object) p; }", I18nSupport.getLabel("invalid.cast.type", TestVfTypeInfos.APEX_PAGE)}};
    }

    @Test(dataProvider="invalidClassData")
    public void testInvalidCastInClass(String code, String expectedError) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"Integer i = +5;"}, {"Account a; a = +a;"}, {"String s = +'foo';"}, {"Integer i = -(1 + 2);"}, {"Long i = -(22L + 1);"}, {"Double d = -(1.9d + 2);"}, {"Decimal d = -(3.14);"}, {"Boolean b = !false;"}, {"Integer i = + (-1);"}, {"Long l = ~10L;"}, {"Integer i = ~10;"}, {"Decimal d; Integer i = (Integer) d;"}, {"Long l; Integer i = (Integer) l;"}, {"Double d; Integer i = (Integer) d;"}, {"Decimal d; Long l = (Long) d;"}, {"Integer i; Long l = (Long) i;"}, {"Double d; Long l = (Long) d;"}, {"Long l; Decimal d = (Decimal) l;"}, {"Double d = 22.654654657d; Decimal d1 = (Decimal) d;"}, {"Integer i; Decimal d = (Decimal) i;"}, {"Decimal dl; Double d = (Double) dl;"}, {"Integer i; Double d = (Double) i;"}, {"Long l; Double d = (Double) l;"}, {"Id id; String i = (String) id;"}, {"String sid; Id id = (Id) sid;"}, {"Date d; DateTime dt = (DateTime) d;"}, {"DateTime dt; Date d = (Date) dt;"}, {"Id id; String s = (String) id;"}, {"String s; Id id = (Id) s;"}, {"List<Account> aList; Account a = (Account) aList;"}, {"Integer i; ++i;"}, {"Integer i; --i;"}, {"Double d; ++d;"}, {"Double d; --d;"}, {"Decimal d; ++d;"}, {"Decimal d; --d;"}, {"Long l; ++l;"}, {"Long l; --l;"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }

    @Test
    public void testInaccessibleCastPrefixExpression() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(ImmutableList.of("public class Foo { private class InnerFoo { } }", "public class Bar { { Object o; Object p = (Foo.InnerFoo)o; } }"), ImmutableList.of(I18nSupport.getLabel("type.not.visible", "Foo.InnerFoo")));
    }

    @Test
    public void testUnassignableInterfaceCast() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccess("public class C1 { }", "public interface I1 { }", "public interface I2 { }", "public class Foo {void Method1() {   C1 c1;    I1 i1;    I2 i2;   i1 = (i1) c1;    c1 = (c1) i1;    i2 = (i2) i1;} }");
    }
}

