/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class NewSetLiteralExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"new Set<String> {true};", I18nSupport.getLabel("invalid.set.initial.expression.type", TypeInfos.STRING, TypeInfos.BOOLEAN)}, {"new Set<String, String> {};", I18nSupport.getLabel("invalid.parameterized.type.count", "Set", 1, 2)}, {"new Set<Integer> {1L};", I18nSupport.getLabel("invalid.set.initial.expression.type", TypeInfos.INTEGER, TypeInfos.LONG)}, {"new Set<String> {foo};", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"new Set<foo> {};", I18nSupport.getLabel("invalid.unresolved.type", "foo")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"new Set<String> {'a', 'b'};"}, {"new Set<String> {'a', null, 'b'};"}, {"new Set<Integer> {12, 23};"}, {"new Set<String> {'a', null, 'b'};"}, {"new Set<Long> {1};"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }

    @Test
    public void testInaccessibleType() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(ImmutableList.of("public class Foo { private class InnerFoo { } }", "public class Bar { { Object o = new Set<Foo.InnerFoo> { null }; } }"), ImmutableList.of(I18nSupport.getLabel("type.not.visible", "Foo.InnerFoo")));
    }
}

