/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class NewSetInitExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"new Set<String>(null);", I18nSupport.getLabel("invalid.set.initializer", null, "String")}, {"new Set<String, String>(1);", I18nSupport.getLabel("invalid.parameterized.type.count", "Set", 1, 2)}, {"new Set<String>(new List<Integer>());", I18nSupport.getLabel("invalid.set.initializer", "List<Integer>", "String")}, {"new Set<String>(new Set<Integer>());", I18nSupport.getLabel("invalid.set.initializer", "Set<Integer>", "String")}, {"new Set<String>(foo);", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"new Set<foo>();", I18nSupport.getLabel("invalid.unresolved.type", "foo")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"new Set<String>();"}, {"new Set<String>(new List<String>(1));"}, {"new Set<String>(new Set<String>());"}};
    }

    @Test(dataProvider="validData")
    public void testValidData(String code) {
        this.tester.assertSuccess(code);
    }

    @Test
    public void testInaccessibleType() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(ImmutableList.of("public class Foo { private class InnerFoo { } }", "public class Bar { { Object o = new Set<Foo.InnerFoo>(); } }"), ImmutableList.of(I18nSupport.getLabel("type.not.visible", "Foo.InnerFoo")));
    }
}

