/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.member.method.SignatureFactory;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class NewObjectExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"class Foo{} Foo f = new Foo(10);", I18nSupport.getLabel("unknown.constructor", "Foo", SignatureFactory.create("<init>", (TypeInfo)TypeInfos.VOID, TypeInfos.INTEGER).getSignatureParameters())}, {"Exception e = new Exception();", I18nSupport.getLabel("type.not.constructable", TypeInfos.EXCEPTION)}, {"String str = new String();", I18nSupport.getLabel("type.not.constructable", TypeInfos.STRING)}, {"class Foo{} Foo f = new Foo(foo);", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"new Foo();", I18nSupport.getLabel("invalid.unresolved.type", "Foo")}, {"new AggregateResult();", I18nSupport.getLabel("sobject.not.constructable", InternalTypeInfos.SOBJECT_AGGREGATE_RESULT)}, {"new Account('foo');", I18nSupport.getLabel("invalid.normal.constructor", "Account")}, {"abstract class Foo {} new Foo();", I18nSupport.getLabel("invalid.new.abstract", "Foo")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"public class Bar { class Foo{ public Foo(){} } Foo f = new Foo(); }"}, {"public class Bar { class Foo{ public Foo(Integer i, String str){} } Foo f = new Foo(10, 'abc'); }"}, {"public class Foo{ public void Bar(){ new java:java.lang.Double(0); } }"}, {"public class Foo{ public void Bar(){ new Component.Apex.Page(); new Component.Apex.Page(name = 'foo'); } }"}, {"public class Foo{ public void Bar(){ new Account(); new Account(name = 'foo'); } }"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.setTrusted(true);
        this.tester.assertSuccess(code);
    }

    @Test
    public void testInaccessibleType() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(ImmutableList.of("public class Foo { private class InnerFoo { } }", "public class Bar { { new Foo.InnerFoo(); } }"), ImmutableList.of(I18nSupport.getLabel("type.not.visible", "Foo.InnerFoo")));
    }

    @Test
    public void testInvalidVFComponentConstructor() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(ImmutableList.of("public class Foo { private void Bar() { new Component.Apex.Page('foo'); } }"), ImmutableList.of(I18nSupport.getLabel("invalid.normal.constructor", "Component.Apex.Page")));
    }
}

