/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.tester.TestSObjectTypeInfos;
import apex.jorje.semantic.tester.TestVfTypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class NewNameValueObjectExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"new Account(nickName = '007');", I18nSupport.getLabel("field.does.not.exist", "nickName", TestSObjectTypeInfos.ACCOUNT)}, {"new Account(name = 'James Bond', Name = '007');", I18nSupport.getLabel("duplicate.field.init", "Name")}, {"new Account(name = 'James Bond', billingCity = name);", I18nSupport.getLabel("variable.does.not.exist", "name")}, {"new Component.apex.InputField(name = 'a');", I18nSupport.getLabel("field.does.not.exist", "name", TestVfTypeInfos.INPUT_FIELD)}, {"new Component.apex.InputField(id = 'a', id='a');", I18nSupport.getLabel("duplicate.field.init", "id")}, {"new Component.apex.InputField(id = firstName);", I18nSupport.getLabel("variable.does.not.exist", "firstName")}, {"new Account(name = 007);", I18nSupport.getLabel("illegal.assignment", "Integer", "String")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"new Account();"}, {"new Account(name = 'John Doe');"}, {"new Account(name = null);"}, {"string firstName = 'John'; string lastName = 'Doe'; Account a = new Account(name = firstName + lastName);"}, {"String firstName; new Component.apex.InputField(id = firstName);"}, {"Integer idInt; new Component.apex.InputField(id = idInt);"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }
}

