/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.TestSObjectTypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.collect.ImmutableList;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class NewMapInitExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"new Map<String>();", new String[]{I18nSupport.getLabel("invalid.parameterized.type.count", "Map", 2, 1)}}, {"new Map<String, Integer, Integer>();", new String[]{I18nSupport.getLabel("invalid.parameterized.type.count", "Map", 2, 3)}}, {"new Map<String, Integer>(new List<Integer>());", new String[]{I18nSupport.getLabel("invalid.map.initializer", ReifiedTypeInfos.INTEGER_LIST, TypeInfos.STRING, TypeInfos.INTEGER)}}, {"new Map<String, Integer>(17);", new String[]{I18nSupport.getLabel("invalid.map.initializer", TypeInfos.INTEGER, TypeInfos.STRING, TypeInfos.INTEGER)}}, {"new Map<String, Account>(new List<Contact>());", new String[]{I18nSupport.getLabel("invalid.map.initializer", GenericTypeInfoFactory.createList(TestSObjectTypeInfos.CONTACT), TypeInfos.STRING, TestSObjectTypeInfos.ACCOUNT)}}, {"new Map<Integer, SObject>(new List<SObject>());", new String[]{I18nSupport.getLabel("invalid.map.initializer", ReifiedTypeInfos.SOBJECT_LIST, TypeInfos.INTEGER, TypeInfos.SOBJECT)}}, {"new Map<String, Integer>(foo);", new String[]{I18nSupport.getLabel("variable.does.not.exist", "foo")}}, {"new Map<String, foo>();", new String[]{I18nSupport.getLabel("invalid.unresolved.type", "foo")}}, {"new Map<foo, Integer>();", new String[]{I18nSupport.getLabel("invalid.unresolved.type", "foo")}}, {"new Map<foo, bar>();", new String[]{I18nSupport.getLabel("invalid.unresolved.type", "foo"), I18nSupport.getLabel("invalid.unresolved.type", "bar")}}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String[] expectedErrors) {
        this.tester.assertFailure(code, expectedErrors);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"new Map<String, Integer>();"}, {"new Map<String, Integer>(new Map<String, Integer>());"}, {"new Map<Id, SObject>(new List<SObject>());"}, {"new Map<Id, Account>(new List<Account>());"}, {"new Map<String, SObject>(new List<SObject>());"}, {"new Map<String, Account>(new List<Account>());"}};
    }

    @Test(dataProvider="validData")
    public void testValidData(String code) {
        this.tester.assertSuccess(code);
    }

    @DataProvider
    Object[][] versionData() {
        return new Object[][]{{"new Map<String,  SObject>();", I18nSupport.getLabel("invalid.sobject.map")}};
    }

    @Test(dataProvider="versionData")
    public void testVersioning(String code, String expectedError) {
        this.tester.setVersion(Version.MIN);
        this.tester.assertFailure(code, expectedError);
    }

    @Test
    public void testInaccessibleKeyType() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(ImmutableList.of("public class Foo { private class InnerFoo { } }", "public class Bar { { Object o = new Map<Integer, Foo.InnerFoo>(); } }"), ImmutableList.of(I18nSupport.getLabel("type.not.visible", "Foo.InnerFoo")));
    }

    @Test
    public void testInaccessibleValueType() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(ImmutableList.of("public class Foo { private class InnerFoo { } }", "public class Bar { { Object o = new Map<Foo.InnerFoo, Integer>(); } }"), ImmutableList.of(I18nSupport.getLabel("type.not.visible", "Foo.InnerFoo")));
    }
}

