/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.collect.ImmutableList;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class NewListInitExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"new List<String>(null);", I18nSupport.getLabel("invalid.list.initializer", "null", "String")}, {"new List<String, String>(1);", I18nSupport.getLabel("invalid.parameterized.type.count", "List", 1, 2)}, {"new List<String>('foobar');", I18nSupport.getLabel("invalid.list.initializer", "String", "String")}, {"new List<String>(new List<Integer>(0));", I18nSupport.getLabel("invalid.list.initializer", "List<Integer>", "String")}, {"new List<String>(foo);", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"new List<foo>();", I18nSupport.getLabel("invalid.unresolved.type", "foo")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"new List<String>();"}, {"new String[1];"}, {"new List<String>(1);"}, {"new List<String>(new List<String>(1));"}, {"new List<String>(new Set<String>());"}};
    }

    @Test(dataProvider="validData")
    public void testValidData(String code) {
        this.tester.assertSuccess(code);
    }

    @DataProvider
    Object[][] versionData() {
        return new Object[][]{{"new List<SObject>();", I18nSupport.getLabel("invalid.sobject.list")}};
    }

    @Test(dataProvider="versionData")
    public void testVersioning(String code, String expectedError) {
        this.tester.setVersion(Version.MIN);
        this.tester.assertFailure(code, expectedError);
    }

    @Test
    public void testInaccessibleType() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(ImmutableList.of("public class Foo { private class InnerFoo { } }", "public class Bar { { Object o = new List<Foo.InnerFoo>(); } }"), ImmutableList.of(I18nSupport.getLabel("type.not.visible", "Foo.InnerFoo")));
    }
}

