/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.tester.TestConstants;
import apex.jorje.semantic.tester.TestSObjectTypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.collect.ImmutableList;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class MethodCallExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidAnonymousData() {
        return new Object[][]{{"String s; s.addError('foo');", I18nSupport.getLabel("method.invalid.add.error.not.sobject.field")}, {"[SELECT Id FROM Account].name.addError('foo');", I18nSupport.getLabel("method.invalid.add.error.not.sobject.scalar.field")}, {"SObjectWithCustomDataTypeField__c obj; obj.CustomDataTypeField__c.addError('test');", I18nSupport.getLabel("method.invalid.add.error.not.sobject.scalar.field")}, {"List<String> s; s.deepClone();", I18nSupport.getLabel("method.invalid.sobject.list", ReifiedTypeInfos.STRING_LIST)}, {"List<String> s; s.deepClone(true);", I18nSupport.getLabel("method.invalid.sobject.list", ReifiedTypeInfos.STRING_LIST)}, {"List<String> s; s.deepClone(true, true);", I18nSupport.getLabel("method.invalid.sobject.list", ReifiedTypeInfos.STRING_LIST)}, {"List<String> s; s.deepClone(true, true, true);", I18nSupport.getLabel("method.invalid.sobject.list", ReifiedTypeInfos.STRING_LIST)}, {"List<String> s; s.getSObjectType();", I18nSupport.getLabel("method.invalid.sobject.list", ReifiedTypeInfos.STRING_LIST)}, {"Map<String, String> m; m.deepClone();", I18nSupport.getLabel("method.invalid.sobject.map", ReifiedTypeInfos.STRING_TO_STRING_MAP)}, {"Map<String, String> m; m.getSObjectType();", I18nSupport.getLabel("method.invalid.sobject.map", ReifiedTypeInfos.STRING_TO_STRING_MAP)}, {"List<Account> aLst = Account.getAll().values();", I18nSupport.getLabel("invalid.custom.settings")}, {"List<Map_Custom_Setting__c> m = Map_Custom_Setting__c.getAll().values();", I18nSupport.getLabel("method.only.list.custom.settings", "Map_Custom_Setting__c")}};
    }

    @Test(dataProvider="invalidAnonymousData")
    public void testInvalidAnonymous(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validAnonymousData() {
        return new Object[][]{{"static void foo() {} void bar() {} class Foo { { foo(); bar(); } }"}, {"Account a; a.name.addError('foo');"}, {"List<SObject> s; s.deepClone();"}, {"List<SObject> s; s.deepClone(true);"}, {"List<SObject> s; s.deepClone(true, true);"}, {"List<SObject> s; s.deepClone(true, true, true);"}, {"List<SObject> s; s.getSObjectType();"}, {"Map<String, SObject> m; m.deepClone();"}, {"Map<String, SObject> m; m.getSObjectType();"}, {"List<List_Custom_Setting__c> lst = List_Custom_Setting__c.getAll().values();"}};
    }

    @Test(dataProvider="validAnonymousData")
    public void testValidAnonymous(String code) {
        this.tester.getAccessEvaluator().addSetupEntityVisibleToType(TestSObjectTypeInfos.LIST_CUSTOM_SETTING, "anon");
        this.tester.assertSuccess(code);
    }

    @DataProvider
    Object[][] invalidNamedData() {
        return new Object[][]{{"public class Foo { static void bar() { nonStatic(); } void nonStatic() {} }", I18nSupport.getLabel("invalid.non.static.method.context", "void Foo.nonStatic()")}, {"public class Foo { static void bar() { Foo.nonStatic(); } void nonStatic() {} }", I18nSupport.getLabel("invalid.non.static.method.context", "void Foo.nonStatic()")}, {"public class Foo { static void bar() { } void nonStatic() { new Foo().bar(); } }", I18nSupport.getLabel("invalid.static.method.context", "void Foo.bar()")}, {"public abstract class Foo { abstract void bar(); public class Bar extends Foo { { super.bar(); } override void bar() {} } }", I18nSupport.getLabel("invalid.abstract.method.call", "void Foo.bar()")}, {"public class Foo { void foo() {} class InnerFoo { { foo(); } } }", I18nSupport.getLabel("invalid.method.not.found", "void foo()", "Foo.InnerFoo")}};
    }

    @Test(dataProvider="invalidNamedData")
    public void testInvalidNamed(String code, String expectedError) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validNamedData() {
        return new Object[][]{{"public class Foo { static void foo() {} class InnerFoo { { foo(); } } }"}};
    }

    @Test(dataProvider="validNamedData")
    public void testValid(String code) {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccess(code);
    }

    @Test
    public void testInaccessibleMethodReturnType() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(ImmutableList.of("public class Foo { private class InnerFoo { } public InnerFoo someMethod() { return null; } }", "public class Bar { { Foo f; f.someMethod(); } }"), ImmutableList.of(I18nSupport.getLabel("method.return.type.not.visible", "Foo.InnerFoo", "Foo.InnerFoo Foo.someMethod()")));
    }

    @Test
    public void testInaccessibleMethodParameterType() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertFailure(ImmutableList.of("public class Foo { private class InnerFoo { } public void someMethod(InnerFoo x) { } }", "public class Bar { { Foo f; f.someMethod(null); } }"), ImmutableList.of(I18nSupport.getLabel("method.parameter.type.not.visible", "Foo.InnerFoo", "void Foo.someMethod(Foo.InnerFoo)")));
    }

    @Test
    public void testInaccessibleCustomSetting() {
        this.tester.setNamespace(TestConstants.NAMESPACE_A);
        this.tester.assertFailure("public class Foo { void doSomething() { NS_Map_Custom_Setting__c.getInstance(); } }", I18nSupport.getLabel("custom.settings.namespace.not.visible", "NS_Map_Custom_Setting__c"));
    }

    @Test
    public void testSObjectGetDifferingFields() {
        this.tester.getAccessEvaluator().setHasPrivateApi(true);
        this.tester.assertFailure("Account a; a.getDifferingFields(new Contact());", I18nSupport.getLabel("invalid.method.not.found", "void getDifferingFields(Contact)", "Account"));
    }

    @Test
    public void testVersionedAbstractCall() {
        this.tester.setVersion(Version.V172);
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccess("public abstract class Foo { abstract void bar(); public class Bar extends Foo { { super.bar(); } override void bar() {} } }");
    }
}

