/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import java.util.Arrays;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class JavaMethodExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
        this.tester.setTrusted(true);
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"java:foo();", I18nSupport.getLabel("invalid.java.expression")}, {"java:foo.bar();", I18nSupport.getLabel("invalid.java.expression.class.not.found", "foo")}, {"java:java.lang.Integer.toString();", I18nSupport.getLabel("invalid.java.expression.method.not.static", "toString", "java.lang.Integer")}, {"java:java.lang.Integer.valueOf(foo);", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"java:java.lang.Integer.foo();", I18nSupport.getLabel("invalid.java.expression.method.not.found", "void foo()", "java.lang.Integer")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] invalidNotTrustedData() {
        return new Object[][]{{"java:java.lang.Integer.valueOf(1);", I18nSupport.getLabel("illegal.java.expression")}};
    }

    @Test(dataProvider="invalidNotTrustedData")
    public void testInvalidNotTrusted(String code, String expectedError) {
        this.tester.setTrusted(false);
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"java:java.lang.Integer.valueOf(1);"}, {"Integer i = java:java.lang.Integer.valueOf(1);"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }

    @Test
    public void testAmbiguousJavaType() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccess(Arrays.asList("public class Foo { public Foo(java:java.lang.Byte b) {} public Foo(Integer i) {} }", "public class Bar { { new Foo(null); } }"));
    }
}

