/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CollectionExpressionUtilsTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
        this.tester.setParserType(ParserWrapper.Type.NAMED);
    }

    @Test
    public void testNoBailingOnUnresolvedTypeError() {
        ArrayList<String> sources = Lists.newArrayList("public class Foo { private class InnerFoo { } }", "public class C { { Object o = new Map<X, Foo.InnerFoo>(); } }");
        ArrayList<String> errors = Lists.newArrayList(I18nSupport.getLabel("invalid.unresolved.type", "X"), I18nSupport.getLabel("type.not.visible", "Foo.InnerFoo"));
        this.tester.assertFailure(sources, errors);
    }

    @Test
    public void testSObjectFailsAsMapValueTypePre164() {
        this.tester.setVersion(Version.V162);
        this.tester.assertFailure("public class C { { Object o = new Map<Integer, SObject>(); } }", I18nSupport.getLabel("invalid.sobject.map"));
    }

    @Test
    public void testSObjectWorksAsMapValueTypeFrom164() {
        this.tester.setVersion(Version.V164);
        this.tester.assertSuccess("public class C { { Object o = new List<SObject>(); } }");
    }

    @Test
    public void testSObjectFailsAsListElementTypePre164() {
        this.tester.setVersion(Version.V162);
        this.tester.assertFailure("public class C { { Object o = new List<SObject>(); } }", I18nSupport.getLabel("invalid.sobject.list"));
    }

    @Test
    public void testSObjectWorksAsListElementTypeFrom164() {
        this.tester.setVersion(Version.V164);
        this.tester.assertSuccess("public class C { { Object o = new List<SObject>(); } }");
    }
}

