/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class BinaryExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"Date d1; d1 = d1 * 1;", I18nSupport.getLabel("invalid.numeric.arguments.expression")}, {"Integer i; i = 1 + true;", I18nSupport.getLabel("invalid.numeric.arguments.expression")}, {"Decimal d; d = 1.0 - 'true';", I18nSupport.getLabel("invalid.numeric.arguments.expression")}, {"Long l; l = 1L * true;", I18nSupport.getLabel("invalid.numeric.arguments.expression")}, {"Integer i; i = 1 / true;", I18nSupport.getLabel("invalid.numeric.arguments.expression")}, {"String s; s = 'ab' - 'cd';", I18nSupport.getLabel("invalid.numeric.arguments.expression")}, {"String s; s = 'ab' * 'cd';", I18nSupport.getLabel("invalid.numeric.arguments.expression")}, {"String s; s = 'ab' / 'cd';", I18nSupport.getLabel("invalid.numeric.arguments.expression")}, {"Integer i; i = 1 & true;", I18nSupport.getLabel("invalid.bitwise.operator.arguments", "&")}, {"Integer i; i = 1 | 'foo';", I18nSupport.getLabel("invalid.bitwise.operator.arguments", "|")}, {"Integer i; i = 1 ^ 2.0;", I18nSupport.getLabel("invalid.bitwise.operator.arguments", "^")}, {"Time t1; t1 = t1 * 1L;", I18nSupport.getLabel("invalid.numeric.arguments.expression")}, {"Time t1; t1 = t1 / 1L;", I18nSupport.getLabel("invalid.numeric.arguments.expression")}, {"Time t1; t1 = t1 + true;", I18nSupport.getLabel("invalid.time.operand.expression")}, {"Date d1; d1 = d1 + true;", I18nSupport.getLabel("invalid.date.operand.expression")}, {"DateTime d1; d1 = d1 + true;", I18nSupport.getLabel("invalid.datetime.operand.expression")}, {"Double d; d = 1.0d << 2;", I18nSupport.getLabel("invalid.shift.operator.arguments", "<<")}, {"Double d; d = 1.0d >> 2;", I18nSupport.getLabel("invalid.shift.operator.arguments", ">>")}, {"Double d; d = 1.0d >>> 2;", I18nSupport.getLabel("invalid.shift.operator.arguments", ">>>")}, {"Void foo(){} void test(){ String str = foo() + 'ab';}", I18nSupport.getLabel("invalid.void.arithmetic.expression")}, {"Boolean b = foo & 1;", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"Boolean b = 1 & foo;", I18nSupport.getLabel("variable.does.not.exist", "foo")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"String s = 'ab' + 1;"}, {"String s = 1 + 'ab';"}, {"Date d1; d1 = d1 + 1;"}, {"Date d1; d1 = d1 - 1L;"}, {"Time t1; t1 = t1 + 1;"}, {"Time t1; t1 = t1 - 1l;"}, {"DateTime d1; d1 = d1 + 1;"}, {"DateTime d1; d1 = d1 - 1.0;"}, {"DateTime d1; d1 = d1 - 1.0d;"}, {"Integer i; i = 1 << 2;"}, {"Long l; l = 10L >> 2;"}, {"Long l; l = 10L >>> 2;"}, {"Boolean b; b = false & true;"}, {"Boolean b; b = false | true;"}, {"Boolean b; b = false ^ true;"}, {"Integer i; i = 1 & 0;"}, {"Integer i; i = 1 | 0;"}, {"Integer i; i = 1 ^ 0;"}, {"Long l; l = 1L & 0;"}, {"Long l; l = 1 | 0L;"}, {"Long l; l = 1L ^ 0L;"}, {"Integer i; i = 1 + 1;"}, {"Long l; l = 1L / 1;"}, {"Double d; d = 1L * 1.0d;"}, {"Decimal d; d = 1.0 + 1.0d;"}, {"String s = (('foo') + ('bar')) + ('foo');"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }

    @DataProvider
    Object[][] invalidOldVersionData() {
        return new Object[][]{{"Integer i = 2 << 2L;", I18nSupport.getLabel("illegal.assignment", TypeInfos.LONG, TypeInfos.INTEGER)}};
    }

    @Test(dataProvider="invalidOldVersionData")
    public void testInvalidOldVersion(String code, String expectedError) {
        this.tester.setVersion(Version.MIN);
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validOldVersionData() {
        return new Object[][]{{"Void v; String str = v + 'ab';"}, {"Void foo(){} String str = foo() + 'ab';"}};
    }

    @Test(dataProvider="validOldVersionData")
    public void testValidOldVersionData(String code) {
        this.tester.setVersion(Version.MIN);
        this.tester.assertSuccess(code);
    }
}

