/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.expression;

import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ArrayExpressionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
    }

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{"Integer i = 'foo'[0];", I18nSupport.getLabel("invalid.list.type", TypeInfos.STRING)}, {"Integer[] a; Integer i = a['foo'];", I18nSupport.getLabel("invalid.list.index.type", TypeInfos.INTEGER, TypeInfos.STRING)}, {"true[0] = 'foo';", I18nSupport.getLabel("invalid.list.type", TypeInfos.BOOLEAN)}, {"Integer[] a; a['foo'] = 1;", I18nSupport.getLabel("invalid.list.index.type", TypeInfos.INTEGER, TypeInfos.STRING)}, {"foo[0] = 1;", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"Integer i = foo[0];", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"Integer[] a; a[foo] = 1;", I18nSupport.getLabel("variable.does.not.exist", "foo")}, {"Integer[] a; Integer i = a[foo];", I18nSupport.getLabel("variable.does.not.exist", "foo")}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalid(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{"Integer[] a; Integer i = a[0];"}, {"Integer[] a; a[0] = 1;"}};
    }

    @Test(dataProvider="validData")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }
}

