/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.compilation;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import java.util.Arrays;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TriggerTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
        this.tester.setParserType(ParserWrapper.Type.NAMED);
    }

    @DataProvider
    Object[][] invalidTriggerUsageData() {
        return new Object[][]{{"trigger Foo on Account (<create>) { public Integer i; }", "unexpected token: '<'"}, {"trigger Foo on Account (before foo) { public Integer i; }", "unexpected token: 'foo'"}};
    }

    @Test(dataProvider="invalidTriggerUsageData")
    public void testInvalidTriggerUsage(String code, String expectedError) {
        this.tester.assertFailure(code, expectedError);
    }

    @Test
    public void testTriggerTypeInaccessible() {
        this.tester.assertFailure(Arrays.asList("trigger Foo on Account (before insert) { public Integer i; }", "public class Bar { Integer j = Foo.i; }"), I18nSupport.getLabel("variable.does.not.exist", "Foo"));
    }

    @Test
    public void testOverrideAccount() {
        this.tester.setParserType(ParserWrapper.Type.NAMED);
        this.tester.assertSuccess("public class Account { }", "trigger Foo on Account (before insert) { public Integer i; }");
    }
}

