/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.compilation;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ExceptionTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
        this.tester.setParserType(ParserWrapper.Type.NAMED);
    }

    @DataProvider
    Object[][] valid() {
        return new Object[][]{{"global virtual class FooException extends Exception { global class MyException extends FooException {} } "}};
    }

    @Test(dataProvider="valid")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }

    @DataProvider
    Object[][] invalidUserExceptionOverrideData() {
        return new Object[][]{{"public class FooException extends Exception { FooException(){} }", I18nSupport.getLabel("invalid.exception.constructor.already.defined", "void <init>()")}, {"public class FooException extends Exception { FooException(String msg){} }", I18nSupport.getLabel("invalid.exception.constructor.already.defined", "void <init>(String)")}, {"public class FooException extends Exception { FooException(Exception e){} }", I18nSupport.getLabel("invalid.exception.constructor.already.defined", "void <init>(Exception)")}, {"public class FooException extends Exception { FooException(String msg, Exception e){} }", I18nSupport.getLabel("invalid.exception.constructor.already.defined", "void <init>(String, Exception)")}};
    }

    @Test(dataProvider="invalidUserExceptionOverrideData")
    public void testInvalidUserExceptionOverrideData(String sources, String expectedError) {
        this.tester.setTrusted(false);
        this.tester.assertFailure(sources, expectedError);
    }

    @DataProvider
    Object[][] validUserExceptionOverrideAllowedInTrustedData() {
        return new Object[][]{{"public class FooException extends Exception { FooException(){} }"}, {"public class FooException extends Exception { FooException(String msg){} }"}, {"public class FooException extends Exception { FooException(Exception e){} }"}, {"public class FooException extends Exception { FooException(String msg, Exception e){} }"}};
    }

    @Test(dataProvider="validUserExceptionOverrideAllowedInTrustedData")
    public void testValidExceptionOverrideAllowedInTrusted(String sources) {
        this.tester.setFileBased(true);
        this.tester.setTrusted(true);
        this.tester.assertSuccess(sources);
    }

    @DataProvider
    Object[][] validUserExceptionOverrideData() {
        return new Object[][]{{"public class FooException extends Exception { FooException(Integer i){} }"}, {"public class FooException extends Exception { FooException(Exception e, String str){} }"}};
    }

    @Test(dataProvider="validUserExceptionOverrideData")
    public void testValidExceptionOverride(String sources) {
        this.tester.setTrusted(false);
        this.tester.assertSuccess(sources);
    }
}

