/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.validation.compilation;

import apex.jorje.semantic.compiler.parser.ParserWrapper;
import apex.jorje.semantic.tester.ValidationTester;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ClassTest {
    private ValidationTester tester;

    @BeforeMethod
    public void setUp() throws Exception {
        this.tester = new ValidationTester();
        this.tester.setParserType(ParserWrapper.Type.NAMED);
    }

    @DataProvider
    Object[][] valid() {
        return new Object[][]{{"global virtual class MyBar { MyBar(Integer i) {} global class MyFoo extends MyBar { MyFoo() { super(1);} } } "}};
    }

    @Test(dataProvider="valid")
    public void testValid(String code) {
        this.tester.assertSuccess(code);
    }

    @Test
    public void testDuplicateName() {
        this.tester.assertFailure(ImmutableList.of("public class Foo {}", "public class Foo {}"), I18nSupport.getLabel("duplicate.type.name", "Foo"));
    }
}

