/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.tester.matchers;

import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import java.util.Arrays;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsType
extends TypeSafeDiagnosingMatcher<TypeInfo> {
    private final TypeInfo expected;

    private IsType(TypeInfo expected) {
        this.expected = expected;
    }

    public static TypeSafeDiagnosingMatcher<TypeInfo> isType(TypeInfo expected) {
        return new IsType(expected);
    }

    public static Matcher<Iterable<? extends TypeInfo>> containsTypes(TypeInfo ... expected) {
        return Matchers.contains(Arrays.stream(expected).map(IsType::isType).collect(MoreIterables.toUnmodifiableList(expected.length)));
    }

    protected boolean matchesSafely(TypeInfo type, Description description) {
        description.appendText("but found (" + type.getClass().getSimpleName() + ") " + type);
        return TypeInfoEquivalence.isEquivalent(this.expected, type);
    }

    public void describeTo(Description description) {
        description.appendText("a type equivalent to (" + this.expected.getClass().getSimpleName() + ") " + this.expected);
    }
}

