/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.tester.matchers;

import apex.jorje.semantic.ast.visitor.reference.ExternalDependency;
import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.tester.matchers.IsTypeWithApexName;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsExternalDependency
extends TypeSafeDiagnosingMatcher<ExternalDependency> {
    private final Matcher<TypeInfo> typeInfoMatcher;
    private final Matcher<FieldInfo> fieldInfoMatcher;
    private final Matcher<DmlOperation> dmlOperationMatcher;

    private IsExternalDependency(Matcher<TypeInfo> typeInfoMatcher, Matcher<FieldInfo> fieldInfoMatcher, Matcher<DmlOperation> dmlOperationMatcher) {
        this.typeInfoMatcher = typeInfoMatcher;
        this.fieldInfoMatcher = fieldInfoMatcher;
        this.dmlOperationMatcher = dmlOperationMatcher;
    }

    public static TypeSafeDiagnosingMatcher<ExternalDependency> dependencyWithType(String apexName) {
        return new IsExternalDependency((Matcher<TypeInfo>)IsTypeWithApexName.hasApexName(apexName), (Matcher<FieldInfo>)Matchers.nullValue(FieldInfo.class), (Matcher<DmlOperation>)Matchers.nullValue(DmlOperation.class));
    }

    public static TypeSafeDiagnosingMatcher<ExternalDependency> dependencyWithDmlOperation(DmlOperation dmlOperation) {
        return new IsExternalDependency((Matcher<TypeInfo>)Matchers.any(TypeInfo.class), (Matcher<FieldInfo>)Matchers.nullValue(FieldInfo.class), (Matcher<DmlOperation>)Matchers.is((Object)((Object)dmlOperation)));
    }

    public static TypeSafeDiagnosingMatcher<ExternalDependency> dependencyWith(String apexName, DmlOperation dmlOperation) {
        return new IsExternalDependency((Matcher<TypeInfo>)IsTypeWithApexName.hasApexName(apexName), (Matcher<FieldInfo>)Matchers.nullValue(FieldInfo.class), (Matcher<DmlOperation>)Matchers.is((Object)((Object)dmlOperation)));
    }

    public static TypeSafeDiagnosingMatcher<ExternalDependency> dependencyWithFieldName(String fieldName) {
        return new IsExternalDependency((Matcher<TypeInfo>)Matchers.any(TypeInfo.class), (Matcher<FieldInfo>)IsExternalDependency.hasBytecodeName((Matcher<String>)Matchers.equalTo((Object)fieldName)), (Matcher<DmlOperation>)Matchers.nullValue(DmlOperation.class));
    }

    public static TypeSafeDiagnosingMatcher<ExternalDependency> userTypeDependencyWithFieldName(String typeInfoName, String fieldName) {
        return new IsExternalDependency((Matcher<TypeInfo>)IsTypeWithApexName.hasApexName(typeInfoName), (Matcher<FieldInfo>)IsExternalDependency.hasBytecodeName((Matcher<String>)Matchers.equalTo((Object)fieldName)), (Matcher<DmlOperation>)Matchers.nullValue(DmlOperation.class));
    }

    public static TypeSafeDiagnosingMatcher<ExternalDependency> userTypeDependencyWithFieldNameAndDml(String typeInfoName, String fieldName, DmlOperation dmlOperation) {
        return new IsExternalDependency((Matcher<TypeInfo>)IsTypeWithApexName.hasApexName(typeInfoName), (Matcher<FieldInfo>)IsExternalDependency.hasBytecodeName((Matcher<String>)Matchers.equalTo((Object)fieldName)), (Matcher<DmlOperation>)Matchers.is((Object)((Object)dmlOperation)));
    }

    public void describeTo(Description description) {
        description.appendText("type info: ");
        this.typeInfoMatcher.describeTo(description);
        description.appendText(" field name: ");
        this.fieldInfoMatcher.describeTo(description);
        description.appendText(" dml op: ");
        this.dmlOperationMatcher.describeTo(description);
    }

    protected boolean matchesSafely(ExternalDependency externalDependency, Description description) {
        return this.typeInfoMatcher.matches((Object)externalDependency.getTypeInfo()) && this.fieldInfoMatcher.matches((Object)externalDependency.getReferenceInfo().getVariable()) && this.dmlOperationMatcher.matches((Object)externalDependency.getReferenceInfo().getDmlOperation());
    }

    private static FeatureMatcher<FieldInfo, String> hasBytecodeName(Matcher<String> matcher) {
        return new FeatureMatcher<FieldInfo, String>(matcher, "name", "name"){

            protected String featureValueOf(FieldInfo actual) {
                return actual.getName();
            }
        };
    }
}

