/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.tester.matchers;

import apex.jorje.data.Loc;
import apex.jorje.services.exception.CompilationException;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsCompilationException<T extends CompilationException>
extends TypeSafeDiagnosingMatcher<T> {
    private final Matcher<Loc> loc;
    private final Matcher<String> message;

    private IsCompilationException(Matcher<Loc> loc, Matcher<String> message) {
        this.loc = loc;
        this.message = message;
    }

    public static Matcher<CompilationException> error(String expected) {
        return new IsCompilationException((Matcher<Loc>)Matchers.any(Loc.class), (Matcher<String>)Matchers.equalTo((Object)expected));
    }

    public void describeTo(Description description) {
        description.appendText("error with loc ");
        this.loc.describeTo(description);
        description.appendText(", message ");
        this.message.describeTo(description);
    }

    protected boolean matchesSafely(CompilationException error, Description description) {
        description.appendText("error with loc ");
        this.loc.describeMismatch((Object)error.getLoc(), description);
        description.appendText(", message ");
        this.message.describeMismatch((Object)error.getError(), description);
        return this.loc.matches((Object)error.getLoc()) && this.message.matches((Object)error.getError());
    }
}

