/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.visibility;

import apex.jorje.data.CompilationUnitBuilder;
import apex.jorje.data.JadtFactory;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.compiler.sfdc.SymbolProvider;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.visibility.VisibleApiVersionUtil;
import apex.jorje.semantic.tester.TestSymbolResolvers;
import apex.jorje.semantic.tester.matchers.IsResultWithError;
import apex.jorje.semantic.tester.matchers.IsResultWithValue;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class VisibleApiVersionUtilTest {
    @Mock
    private SourceFile source;
    @Mock
    private SymbolProvider symbolProvider;
    @Mock
    private AccessEvaluator accessEvaluator;
    private SymbolResolver symbols;
    private TypeInfo type;

    @BeforeMethod
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.source.getNamespace()).thenReturn((Object)Namespaces.EMPTY);
        this.type = ((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setFileBase(this.source, CompilationUnitBuilder.emptyClass((String)"FooClass"))).build();
        this.symbols = TestSymbolResolvers.createTestSymbols(this.symbolProvider, this.accessEvaluator, null);
    }

    @Test
    public void testNoAnnotationProvided() {
        ModifierGroup modifiers = ModifierGroup.builder().addModifiers(ModifierTypeInfos.PUBLIC).build();
        Result<Void> result = VisibleApiVersionUtil.checkApiVisible(this.symbols, this.type, "mymethod", modifiers, Member.Type.METHOD);
        MatcherAssert.assertThat(result, IsResultWithValue.none());
    }

    @Test
    public void testSourceFileIsTrusted() {
        Mockito.when((Object)this.source.isTrusted()).thenReturn((Object)true);
        this.assertThatVersion(null, this.symbols, IsResultWithValue.none());
    }

    @Test
    public void testMethodMinApiVersion() {
        String methodName = "mymethod";
        Mockito.when((Object)((Object)this.source.getVersion())).thenReturn((Object)Version.V160);
        ModifierGroup modifiers = ModifierGroup.builder().addAnnotationAndResolve(JadtFactory.annotationKeyValues("VisibleApiVersion", "minApiVersion", "162")).build().resolve();
        Result<Void> result = VisibleApiVersionUtil.checkApiVisible(this.symbols, this.type, "mymethod", modifiers, Member.Type.METHOD);
        MatcherAssert.assertThat(result, IsResultWithError.error(I18nSupport.getLabel("not.visible.min.version", "Method", "mymethod", "17.0")));
    }

    @Test
    public void testMethodMaxApiVersion() {
        String methodName = "mymethod";
        Mockito.when((Object)((Object)this.source.getVersion())).thenReturn((Object)Version.CURRENT);
        ModifierGroup modifiers = ModifierGroup.builder().addAnnotationAndResolve(JadtFactory.annotationKeyValues("VisibleApiVersion", "maxApiVersion", "178")).build().resolve();
        Result<Void> result = VisibleApiVersionUtil.checkApiVisible(this.symbols, this.type, "mymethod", modifiers, Member.Type.METHOD);
        MatcherAssert.assertThat(result, IsResultWithError.error(I18nSupport.getLabel("not.visible.max.version", "Method", "mymethod", "25.0")));
    }

    @Test
    public void testVariableMinApiVersion() {
        Mockito.when((Object)((Object)this.source.getVersion())).thenReturn((Object)Version.V160);
        String variableName = "myvar";
        this.assertThatVersion("myvar", this.symbols, (Matcher<Result<Void>>)IsResultWithError.error(I18nSupport.getLabel("not.visible.min.version", "Field", "myvar", "17.0")));
    }

    @Test
    public void testVariableMaxApiVersion() {
        String fieldName = "myfield";
        Mockito.when((Object)((Object)this.source.getVersion())).thenReturn((Object)Version.CURRENT);
        ModifierGroup modifiers = ModifierGroup.builder().addAnnotationAndResolve(JadtFactory.annotationKeyValues("VisibleApiVersion", "maxApiVersion", "178")).build().resolve();
        Result<Void> result = VisibleApiVersionUtil.checkApiVisible(this.symbols, this.type, "myfield", modifiers, Member.Type.FIELD);
        MatcherAssert.assertThat((Object)result.getError(), (Matcher)Matchers.is((Object)I18nSupport.getLabel("not.visible.max.version", "Field", "myfield", "25.0")));
    }

    @Test
    public void testReservedNamespaceSkipsCheck() {
        Mockito.when((Object)this.source.getNamespace()).thenReturn((Object)Namespaces.APEX);
        Mockito.when((Object)this.accessEvaluator.isAccessibleSystemNamespace(Namespaces.APEX)).thenReturn((Object)true);
        this.type = ((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setFileBase(this.source, CompilationUnitBuilder.emptyClass((String)"FooClass"))).build();
        this.assertThatVersion(null, this.symbols, IsResultWithValue.none());
    }

    @Test
    public void testIsSfdcSkipsCheck() {
        Mockito.when((Object)this.accessEvaluator.isSfdc()).thenReturn((Object)true);
        this.assertThatVersion(null, this.symbols, IsResultWithValue.none());
    }

    @Test
    public void testHasInternalSfdcSkipsCheck() {
        Mockito.when((Object)this.accessEvaluator.hasInternalSfdc()).thenReturn((Object)true);
        this.assertThatVersion(null, this.symbols, IsResultWithValue.none());
    }

    @Test
    public void testPresent() {
        String memberName = "testVar";
        IsResultWithError present = IsResultWithError.error(I18nSupport.getLabel("not.visible.min.version", "Field", "testVar", "17.0"));
        this.assertThatVersion("testVar", this.symbols, (Matcher<Result<Void>>)present);
    }

    private void assertThatVersion(String memberName, SymbolResolver symbols, Matcher<Result<Void>> matcher) {
        Mockito.when((Object)((Object)this.source.getVersion())).thenReturn((Object)Version.V160);
        ModifierGroup modifiers = ModifierGroup.builder().addAnnotationAndResolve(JadtFactory.annotationKeyValues("VisibleApiVersion", "minApiVersion", "162")).build().resolve();
        Result<Void> result = VisibleApiVersionUtil.checkApiVisible(symbols, this.type, memberName, modifiers, Member.Type.FIELD);
        MatcherAssert.assertThat(result, matcher);
    }
}

