/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.visibility;

import apex.jorje.semantic.ast.modifier.AnnotationParameter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierOrAnnotation;
import apex.jorje.semantic.common.Result;
import apex.jorje.semantic.common.VoidResult;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import java.text.DecimalFormat;

public final class VisibleApiVersionUtil {
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("#.0");

    public static Result<Void> checkApiVisible(SymbolResolver symbols, TypeInfo referencingType, String memberName, ModifierGroup targetModifiers, Member.Type type) {
        AnnotationParameter maxApiParameter;
        ModifierOrAnnotation annotation = targetModifiers.get(AnnotationTypeInfos.VISIBLE_API_VERSION);
        if (annotation == null) {
            return VoidResult.of();
        }
        Version version = referencingType.getCodeUnitDetails().getVersion();
        if (VisibleApiVersionUtil.skipVersionCheck(symbols, referencingType)) {
            return VoidResult.of();
        }
        AnnotationParameter minApiParameter = annotation.getParameter("minApiVersion");
        if (minApiParameter != null) {
            assert (type != Member.Type.NONE && type != Member.Type.LOCAL);
            int minApi = minApiParameter.getIntegerValue();
            Version minApiVersion = Version.fromInternal(minApi);
            if (version.isLessThan(minApiVersion)) {
                return Result.error(I18nSupport.getLabel("not.visible.min.version", type.getNameForMessage(), memberName, NUMBER_FORMAT.format(minApiVersion.toExternal())));
            }
        }
        if ((maxApiParameter = annotation.getParameter("maxApiVersion")) != null) {
            assert (type != Member.Type.NONE && type != Member.Type.LOCAL);
            int maxApi = maxApiParameter.getIntegerValue();
            Version maxApiVersion = Version.fromInternal(maxApi);
            if (version.isGreaterThan(maxApiVersion)) {
                return Result.error(I18nSupport.getLabel("not.visible.max.version", type.getNameForMessage(), memberName, NUMBER_FORMAT.format(maxApiVersion.toExternal())));
            }
        }
        return VoidResult.of();
    }

    private static boolean skipVersionCheck(SymbolResolver symbols, TypeInfo referencingType) {
        return referencingType.getCodeUnitDetails().isTrusted() || symbols.getAccessEvaluator().isAccessibleSystemNamespace(referencingType.getNamespace()) || symbols.getAccessEvaluator().isSfdc() || symbols.getAccessEvaluator().hasInternalSfdc();
    }
}

