/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.visibility;

import apex.jorje.semantic.symbol.visibility.ValidationTest;
import apex.jorje.semantic.tester.TestConstants;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.collect.ImmutableListMultimap;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class VisibilityTest
extends ValidationTest {
    private static final String PUBLIC_FOO_WITH_FIELD = "public virtual class Foo { #modifier# Integer i; }";
    private static final String PUBLIC_FOO_WITH_PROPERTY = "public virtual class Foo { public Integer i { #modifier# get; #modifier# set; } }";
    private static final String PUBLIC_FOO_WITH_DEFAULT_FIELD = "public virtual class Foo { #modifier# Integer i; }".replace("#modifier#", "");
    private static final String PUBLIC_FOO_WITH_PRIVATE_FIELD = "public virtual class Foo { #modifier# Integer i; }".replace("#modifier#", "private");
    private static final String PUBLIC_FOO_WITH_PROTECTED_FIELD = "public virtual class Foo { #modifier# Integer i; }".replace("#modifier#", "protected");
    private static final String PUBLIC_FOO_WITH_PUBLIC_FIELD = "public virtual class Foo { #modifier# Integer i; }".replace("#modifier#", "public");
    private static final String GLOBAL_FOO_WITH_GLOBAL_FIELD = "global class Foo { global Integer i; }";
    private static final String PUBLIC_FOO_WITH_DEFAULT_PROPERTY = "public virtual class Foo { public Integer i { #modifier# get; #modifier# set; } }".replace("#modifier#", "");
    private static final String PUBLIC_FOO_WITH_PRIVATE_PROPERTY = "public virtual class Foo { public Integer i { #modifier# get; #modifier# set; } }".replace("#modifier#", "private");
    private static final String PUBLIC_FOO_WITH_PROTECTED_PROPERTY = "public virtual class Foo { public Integer i { #modifier# get; #modifier# set; } }".replace("#modifier#", "protected");

    @DataProvider
    Object[][] invalidData() {
        return new Object[][]{{new String[]{PUBLIC_FOO_WITH_DEFAULT_FIELD, "public class Bar { { Foo f = new Foo(); f.i = 1; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.i")}}, {new String[]{PUBLIC_FOO_WITH_DEFAULT_FIELD, "public class Bar extends Foo { { i = 5; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.i")}}, {new String[]{PUBLIC_FOO_WITH_PRIVATE_FIELD, "public class Bar { { Foo f = new Foo(); f.i = 1; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.i")}}, {new String[]{PUBLIC_FOO_WITH_PRIVATE_FIELD, "public class Bar extends Foo { { i = 5; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.i")}}, {new String[]{PUBLIC_FOO_WITH_PROTECTED_FIELD, "public class Bar { { Foo f = new Foo(); f.i = 1; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.i")}}, {new String[]{PUBLIC_FOO_WITH_PRIVATE_PROPERTY, "public class Bar { { Foo f = new Foo(); f.i = 1; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.i")}}, {new String[]{PUBLIC_FOO_WITH_PRIVATE_PROPERTY, "public class Bar extends Foo { { i = 5; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.i")}}, {new String[]{PUBLIC_FOO_WITH_PROTECTED_PROPERTY, "public class Bar { { Foo f = new Foo(); f.i = 1; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.i")}}, {new String[]{PUBLIC_FOO_WITH_DEFAULT_FIELD, "public class Bar { { Foo f = new Foo(); Integer j = f.i; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.i")}}, {new String[]{PUBLIC_FOO_WITH_DEFAULT_FIELD, "public class Bar extends Foo { { Integer j = i ; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.i")}}, {new String[]{PUBLIC_FOO_WITH_PRIVATE_FIELD, "public class Bar { { Foo f = new Foo(); Integer j = f.i; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.i")}}, {new String[]{PUBLIC_FOO_WITH_PRIVATE_FIELD, "public class Bar extends Foo { { Integer j = i ; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.i")}}, {new String[]{PUBLIC_FOO_WITH_PROTECTED_FIELD, "public class Bar { { Foo f = new Foo(); Integer j = f.i; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.i")}}, {new String[]{PUBLIC_FOO_WITH_PRIVATE_PROPERTY, "public class Bar { { Foo f = new Foo(); Integer j = f.i; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.i")}}, {new String[]{PUBLIC_FOO_WITH_PRIVATE_PROPERTY, "public class Bar extends Foo { { Integer j = i ; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.i")}}, {new String[]{PUBLIC_FOO_WITH_PROTECTED_PROPERTY, "public class Bar { { Foo f = new Foo(); Integer j = f.i; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.i")}}, {new String[]{"public class Foo { void bar() {} }", "public class Bar { { Foo f = new Foo(); f.bar(); } }"}, new String[]{I18nSupport.getLabel("method.not.visible", "void Foo.bar()")}}, {new String[]{"public class Foo { private void bar() {} }", "public class Bar { { Foo f = new Foo(); f.bar(); } }"}, new String[]{I18nSupport.getLabel("method.not.visible", "void Foo.bar()")}}, {new String[]{"public class Foo { private void bar(Integer x) {} }", "public class Bar { { Foo f = new Foo(); f.bar(42); } }"}, new String[]{I18nSupport.getLabel("method.not.visible", "void Foo.bar(Integer)")}}, {new String[]{"public class Foo { private void bar(Integer x, List<String> someList) {} }", "public class Bar { { Foo f = new Foo(); f.bar(42, new List<String>()); } }"}, new String[]{I18nSupport.getLabel("method.not.visible", "void Foo.bar(Integer, List<String>)")}}, {new String[]{"public virtual class Foo { protected void bar() {} }", "public class Bar { { Foo f = new Foo(); f.bar(); } }"}, new String[]{I18nSupport.getLabel("method.not.visible", "void Foo.bar()")}}, {new String[]{"public virtual class Foo { private void bar() {} }", "public class Bar extends Foo { { this.bar(); } }"}, new String[]{I18nSupport.getLabel("method.not.visible", "void Foo.bar()")}}, {new String[]{"public class Foo { private class Foo1 {} }", "public class Bar { public Foo.Foo1 b1() { return null; } }"}, new String[]{I18nSupport.getLabel("type.not.visible", "Foo.Foo1")}}, {new String[]{"public class Foo { private class Foo1 {} public Foo1 bar() { return null; } }", "public class Bar { public void b1(Foo.Foo1 f) {} }"}, new String[]{I18nSupport.getLabel("type.not.visible", "Foo.Foo1")}}, {new String[]{"public class Foo { private class InnerFoo { } }", "public class Bar { Foo.InnerFoo f; }"}, new String[]{I18nSupport.getLabel("type.not.visible", "Foo.InnerFoo")}}, {new String[]{"public virtual class Foo { public Integer p { set; } }", "public class Bar extends Foo { Integer p { set; } }", "public class Splat { { Bar b = new Bar(); b.p = 1;} }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Bar.p")}}, {new String[]{"public virtual class Foo { public Integer p { get; } }", "public class Bar extends Foo { Integer p { get; } }", "public class Splat { { Bar b = new Bar(); integer i = b.p;} }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Bar.p")}}, {new String[]{"public class Foo {  Integer p { set; } { Integer i = p; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.p")}}, {new String[]{"public class Foo {  Integer p { get; } { p = 1; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.p")}}, {new String[]{"public class Foo {  static Integer p { get; } { Foo.p = 1; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.p")}}, {new String[]{"public class Foo {  static Integer p { get; } }", "public class Bar { { Foo.p = 1; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.p")}}, {new String[]{"public class Foo {  static Integer p { private get; } }", "public class Bar { { Integer i = Foo.p; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "Foo.p")}}, {new String[]{"public class Foo { private class InnerFoo { } }", "public class Bar { List<Foo.InnerFoo> f; }"}, new String[]{I18nSupport.getLabel("type.not.visible", "List<Foo.InnerFoo>")}}, {new String[]{"public class Foo { private class InnerFoo { } }", "public class Bar { { List<Foo.InnerFoo> f; } }"}, new String[]{I18nSupport.getLabel("type.not.visible", "List<Foo.InnerFoo>")}}};
    }

    @Test(dataProvider="invalidData")
    public void testInvalidData(String[] sources, String[] expectedErrors) {
        this.tester.assertFailure(sources, expectedErrors);
    }

    @DataProvider
    Object[][] invalidNamespaceData() {
        return new Object[][]{{new String[]{"global class Foo { public void bar() {} }"}, new String[]{"public class Bar { { NamespaceA.Foo f = new NamespaceA.Foo(); f.bar(); } }"}, new String[]{I18nSupport.getLabel("method.not.visible", "void NamespaceA.Foo.bar()")}}, {new String[]{"global virtual class Foo { protected void bar() {} }"}, new String[]{"public class Bar { { NamespaceA.Foo f = new NamespaceA.Foo(); f.bar(); } }"}, new String[]{I18nSupport.getLabel("method.not.visible", "void NamespaceA.Foo.bar()")}}, {new String[]{"global virtual class Foo { protected void bar() {} }"}, new String[]{"public class Bar extends NamespaceA.Foo { { this.bar(); } }"}, new String[]{I18nSupport.getLabel("method.not.visible", "void NamespaceA.Foo.bar()")}}, {new String[]{"global class Foo { public Integer i; }"}, new String[]{"public class Bar { { NamespaceA.Foo f = new NamespaceA.Foo(); f.i=1; } }"}, new String[]{I18nSupport.getLabel("variable.not.visible", "NamespaceA.Foo.i")}}, {new String[]{"public class Foo { }"}, new String[]{"public class Bar { NamespaceA.Foo f; }"}, new String[]{I18nSupport.getLabel("type.not.visible", "NamespaceA.Foo")}}};
    }

    @Test(dataProvider="invalidNamespaceData")
    public void testInvalidNamespaceData(String[] sourcesInNamespaceA, String[] sourcesInNamespaceB, String[] expectedErrors) {
        this.tester.assertFailures(((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)ImmutableListMultimap.builder().putAll((Object)TestConstants.NAMESPACE_A, sourcesInNamespaceA)).putAll((Object)TestConstants.NAMESPACE_B, sourcesInNamespaceB)).build(), expectedErrors);
    }

    @DataProvider
    Object[][] validData() {
        return new Object[][]{{new String[]{"public class Foo { static Integer i; class Bar { { i = 1; } } }"}}, {new String[]{"global class Foo { static global Integer i; class Bar { { i = 1; } } }"}}, {new String[]{"public class Foo { static public Integer i; class Bar { { i = 1; } } }"}}, {new String[]{"public class Foo { static private Integer i; class Bar { { i = 1; } } }"}}, {new String[]{PUBLIC_FOO_WITH_PUBLIC_FIELD, "public class Bar { { Foo f = new Foo(); f.i = 1; } }"}}, {new String[]{GLOBAL_FOO_WITH_GLOBAL_FIELD, "public class Bar { { Foo f = new Foo(); f.i = 1; } }"}}, {new String[]{PUBLIC_FOO_WITH_PROTECTED_FIELD, "public class Bar extends Foo { { i = 5; } }"}}, {new String[]{"public class Foo { void bar() {} private class Bar { { Foo f = new Foo(); f.bar(); } } }"}}, {new String[]{"public class Foo { private void bar() {} private class Bar { { Foo f = new Foo(); f.bar(); } } }"}}, {new String[]{"public virtual class Foo { protected void bar() {} private class Bar { { Foo f = new Foo(); f.bar(); } } }"}}, {new String[]{"public virtual class Foo { protected void bar() {} private class Bar extends Foo { { this.bar(); } } }"}}, {new String[]{"public virtual class Foo { protected void bar() {} }", "public class Bar extends Foo { { this.bar(); } }"}}, {new String[]{PUBLIC_FOO_WITH_DEFAULT_PROPERTY, "public class Bar { { Foo f = new Foo(); f.i = 1; } }"}}, {new String[]{PUBLIC_FOO_WITH_DEFAULT_PROPERTY, "public class Bar extends Foo { { i = 5; } }"}}, {new String[]{PUBLIC_FOO_WITH_DEFAULT_PROPERTY, "public class Bar { { Foo f = new Foo(); Integer j = f.i; } }"}}, {new String[]{PUBLIC_FOO_WITH_DEFAULT_PROPERTY, "public class Bar extends Foo { { Integer j = i ; } }"}}, {new String[]{"public class Foo { public static Foo f = new Foo(200); public Foo(Integer c) { prop = c; } public integer prop { get; set; } }", "public class Bar { { Foo.f.prop = 1; } }"}}, {new String[]{"public class Foo { public static Foo f = new Foo(200); public Foo(Integer c) { prop = c; } public integer prop { get; set; } }", "public class Bar { { integer i = Foo.f.prop; } }"}}, {new String[]{"public class Foo { public static Foo f = new Foo(200); public Foo(Integer c) { prop = c; } public integer prop { get; set; } }", "public class Bar { { Foo f = new Foo(10); f.prop = 1; } }"}}, {new String[]{"public class Foo { public Foo(Integer c) { prop = c; } public integer prop { get; set; } }", "public class Bar { { Foo f = new Foo(10); integer i = f.prop; } }"}}, {new String[]{"public class Foo { public class InnerFoo { public InnerFoo(Integer c) { prop = c; } public integer prop { get; set; } } }", "public class Bar { { Foo.InnerFoo f = new Foo.InnerFoo(10); integer i = f.prop; } }"}}, {new String[]{"public class Foo { public static integer prop { get; set; } }", "public class Bar {{ integer i = Foo.prop; }}"}}, {new String[]{"public virtual class Foo { Integer prop { get; } }", "public class Bar extends Foo { public Integer prop { set; } }", "public class Splat { { Bar b = new Bar(); b.prop = 1;} }"}}, {new String[]{"public virtual class Foo { Integer prop { set; } }", "public class Bar extends Foo { public Integer prop { get; } }", "public class Splat { { Bar b = new Bar(); integer i = b.prop;} }"}}, {new String[]{"public virtual class Foo { public Integer prop { set; } }", "public class Bar extends Foo { }", "public class Splat { { Bar b = new Bar(); b.prop = 1;} }"}}, {new String[]{"public virtual class Foo { public Integer prop { get; } }", "public class Bar extends Foo { }", "public class Splat { { Bar b = new Bar(); integer i = b.prop;} }"}}, {new String[]{"public virtual class Foo { Integer prop { set; } }", "public class Bar extends Foo { public Integer prop { public set; } }", "public class Splat { { Bar b = new Bar(); b.prop = 1;} }"}}, {new String[]{"public virtual class Foo { Integer prop { get; } }", "public class Bar extends Foo { public Integer prop { public get; } }", "public class Splat { { Bar b = new Bar(); integer i = b.prop;} }"}}, {new String[]{"public class Foo { }", "public class Bar { Foo f; }"}}, {new String[]{"public class Foo { private class InnerFoo { } InnerFoo f; }"}}, {new String[]{"public class Foo { private class InnerFoo { } public class InnerBar { InnerFoo f; } }"}}};
    }

    @Test(dataProvider="validData")
    public void testValidData(String[] sources) {
        this.tester.assertSuccess(sources);
    }

    @Test
    public void testInaccessibleGenericTypeList() {
        this.tester.assertFailure(new String[]{"public class Foo { private class InnerFoo { } }", "public class Bar { List<Foo.InnerFoo> f; }"}, I18nSupport.getLabel("type.not.visible", "List<Foo.InnerFoo>"));
    }

    @Test
    public void testInaccessibleGenericTypeSet() {
        this.tester.assertFailure(new String[]{"public class Foo { private class InnerFoo { } }", "public class Bar { Set<Foo.InnerFoo> f; }"}, I18nSupport.getLabel("type.not.visible", "Set<Foo.InnerFoo>"));
    }

    @Test
    public void testInaccessibleGenericTypeMapValue() {
        this.tester.assertFailure(new String[]{"public class Foo { private class InnerFoo { } }", "public class Bar { Map<Integer, Foo.InnerFoo> f; }"}, I18nSupport.getLabel("type.not.visible", "Map<Integer, Foo.InnerFoo>"));
    }

    @Test
    public void testInaccessibleGenericTypeMapKey() {
        this.tester.assertFailure(new String[]{"public class Foo { private class InnerFoo { } }", "public class Bar { Map<Foo.InnerFoo, Integer> f; }"}, I18nSupport.getLabel("type.not.visible", "Map<Foo.InnerFoo, Integer>"));
    }

    @Test
    public void testInaccessibleGenericUserDefinedType() {
        this.tester.setVersion(Version.V176);
        this.tester.assertFailure(new String[]{"public class Foo { private class InnerFoo { } }", "public interface IFace<T> { }", "public class ConcreteType implements IFace<Foo.InnerFoo> { }"}, I18nSupport.getLabel("type.not.visible", "IFace<Foo.InnerFoo>"));
    }

    @Test
    public void testAccessibleGenericArgumentInnerClass() {
        this.tester.setVersion(Version.V176);
        this.tester.assertSuccess("public interface IFace<T> { }", "public class Foo implements IFace<Foo.InnerFoo> { private class InnerFoo { } }");
    }

    @Test
    public void testAccessibleInnerClassAsBaseType() {
        this.tester.assertSuccess("public virtual class Foo extends InnerFoo { virtual class InnerFoo { } }", "public class Bar extends Foo { }");
    }

    @Test
    public void testAccessibleInnerInterfaceAsBaseTypeForAnotherInnerClass() {
        this.tester.assertSuccess("public class OuterClass { private interface foo { } public class bar implements foo { } }");
    }

    @Test
    public void testAccessibleInnerInterfaceAsBaseType() {
        this.tester.assertSuccess("public virtual class Foo implements IInnerFoo { interface IInnerFoo { } }", "public class Bar extends Foo { }");
    }

    @Test
    public void testInaccessibleInnerClassAsBaseType() {
        this.tester.assertFailure(new String[]{"public virtual class Foo { virtual class InnerFoo { } }", "public class Bar extends Foo.InnerFoo { }"}, I18nSupport.getLabel("type.not.visible", "Foo.InnerFoo"));
    }

    @Test
    public void testInaccessibleInnerInterfaceAsBaseType() {
        this.tester.assertFailure(new String[]{"public virtual class Foo { interface IInnerFoo { } }", "public class Bar implements Foo.IInnerFoo { }"}, I18nSupport.getLabel("type.not.visible", "Foo.IInnerFoo"));
    }

    @Test
    public void testTestVisibilityPrivateFieldFromTestClassNotMethod() {
        this.tester.assertSuccess("public class Code { @TestVisible private Integer i; }", "@isTest public class Test { { Code c; Integer f = c.i; } }");
    }

    @Test
    public void testTestVisibilityPrivateFieldFromTestClassMethod() {
        this.tester.assertSuccess("public class Code { @TestVisible private Integer i; }", "@isTest public class Test { void m() { Code c; Integer f = c.i; } }");
    }

    @Test
    public void testTestVisibilityPrivateFieldFromTestMethod() {
        this.tester.setVersion(Version.V174);
        this.tester.assertSuccess("public class Code { @TestVisible private Integer i; }", "public class Test { TestMethod static void m() { Code c; Integer f = c.i; } }");
    }

    @Test
    public void testTestVisibilityPrivateFieldFromIsTestMethod() {
        this.tester.setVersion(Version.V174);
        this.tester.assertSuccess("public class Code { @TestVisible private Integer i; }", "public class Test { @IsTest static void m() { Code c; Integer f = c.i; } }");
    }

    @Test
    public void testTestVisibilityPrivateClassFromTestClassNotMethod() {
        this.tester.assertSuccess("public class Code { @TestVisible private class InnerCode { } }", "@isTest public class Test { { Code c; } }");
    }

    @Test
    public void testTestVisibilityPrivateClassFromTestClassIsTestMethod() {
        this.tester.assertSuccess("public class Code { @TestVisible private class InnerCode { } }", "@isTest public class Test { @isTest public static void m() { Code c; } }");
    }

    @Test
    public void testTestVisibilityPrivateClassFromTestClassTestMethodMethod() {
        this.tester.assertSuccess("public class Code { @TestVisible private class InnerCode { } }", "@isTest public class Test { TestMethod public static void m() { Code c; } }");
    }

    @Test
    public void testTestVisibilityPrivateClassFromNonTestClassTestMethodMethod() {
        this.tester.setVersion(Version.V174);
        this.tester.assertSuccess("public class Code { @TestVisible private class InnerCode { } }", "public class Test { TestMethod public static void m() { Code c; } }");
    }

    @Test
    public void testTestVisibilityPrivateClassFromNonTestClassIsTestMethod() {
        this.tester.setVersion(Version.V174);
        this.tester.assertSuccess("public class Code { @TestVisible private class InnerCode { } }", "public class Test { @isTest public static void m() { Code c; } }");
    }

    @Test
    public void testTestVisibilityBlockedOnDifferentNamespaces() {
        this.tester.assertFailures(((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)ImmutableListMultimap.builder().putAll((Object)TestConstants.NAMESPACE_A, new String[]{"global class Bar { @TestVisible private class Foo { } }"})).putAll((Object)TestConstants.NAMESPACE_B, new String[]{"@isTest public class Bar { NamespaceA.Bar.Foo f; }"})).build(), I18nSupport.getLabel("type.not.visible", "NamespaceA.Bar.Foo"));
    }

    @Test
    public void testTestVisibilityOnPrivateMethod() {
        this.tester.assertSuccess("public class MainClass { @TestVisible private static void Method1() { } }", "@isTest public class TestClass { public static void TestMethod1() { MainClass.Method1(); } }");
    }

    @Test
    public void testTestVisibilityOuterTypeMarkedIsTest() {
        this.tester.assertSuccess("public class SomeClass { @TestVisible private class HiddenClass { } }", "@isTest public class TestClass { private class InnerTestClass { SomeClass.HiddenClass c; } }");
    }

    @Test
    public void testTestVisibilityBlockedOnSiblingInnerTypeMarkedIsTest() {
        this.tester.assertFailure(new String[]{"public class SomeClass { @TestVisible private class HiddenClass1 { } private class HiddenClass2 { } }", "@isTest public class TestClass { private class InnerTestClass { SomeClass.HiddenClass2 c; } }"}, I18nSupport.getLabel("type.not.visible", "SomeClass.HiddenClass2"));
    }
}

