/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.visibility;

import apex.jorje.semantic.ast.modifier.AnnotationParameter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.ast.modifier.StandardAnnotationsUtil;
import apex.jorje.semantic.bcl.validators.JavaSfdcOnlyAnnotation;
import apex.jorje.semantic.common.iterable.MoreIterables;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.compiler.sfdc.PlaceholderOrgPerm;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.MemberVisitor;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.DynamicFieldInfo;
import apex.jorje.semantic.symbol.member.variable.PropertyInfo;
import apex.jorje.semantic.symbol.member.variable.StandardPropertyInfo;
import apex.jorje.semantic.symbol.member.variable.TriggerPropertyInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.semantic.symbol.visibility.PackagingVersionVisibility;
import apex.jorje.services.I18nSupport;
import java.util.ArrayList;
import java.util.List;

public class Visibility {
    public static int getScore(ModifierGroup modifiers) {
        if (modifiers.has(ModifierTypeInfos.GLOBAL)) {
            return 4;
        }
        if (modifiers.has(ModifierTypeInfos.PUBLIC)) {
            return 3;
        }
        if (modifiers.has(ModifierTypeInfos.PROTECTED)) {
            return 2;
        }
        return 0;
    }

    public static ModifierTypeInfo getHighestVisibilityModifier(ModifierGroup modifiers) {
        if (modifiers.has(ModifierTypeInfos.GLOBAL)) {
            return ModifierTypeInfos.GLOBAL;
        }
        if (modifiers.has(ModifierTypeInfos.PUBLIC)) {
            return ModifierTypeInfos.PUBLIC;
        }
        if (modifiers.has(ModifierTypeInfos.PROTECTED)) {
            return ModifierTypeInfos.PROTECTED;
        }
        return ModifierTypeInfos.PRIVATE;
    }

    public static boolean isLowerForOverride(ModifierGroup parent, ModifierGroup child) {
        int parentScore = Visibility.getScore(parent);
        int childScore = Visibility.getScore(child);
        int modifiedParentScore = parentScore == 4 ? 3 : parentScore;
        return modifiedParentScore > childScore;
    }

    public static List<String> calculateTypeVisibilityErrors(AccessEvaluator accessEvaluator, TypeInfo referencingType, Iterable<TypeInfo> typesToCheck, boolean isReferencedFromTestMethod) {
        ArrayList<String> errors = new ArrayList<String>();
        for (TypeInfo type : typesToCheck) {
            if (Visibility.isTypeVisible(accessEvaluator, referencingType, type, isReferencedFromTestMethod)) continue;
            errors.add(I18nSupport.getLabel("type.not.visible", type.getApexName()));
        }
        return errors;
    }

    public static boolean isTypeVisible(AccessEvaluator accessEvaluator, TypeInfo referencingType, TypeInfo targetType, boolean isReferencedFromTestMethod) {
        return Visibility.isTypeVisible(accessEvaluator, referencingType, targetType, isReferencedFromTestMethod, false);
    }

    public static boolean isTypeVisibleInImplicitReference(AccessEvaluator accessEvaluator, TypeInfo referencingType, TypeInfo targetType, boolean isReferencedFromTestMethod) {
        return Visibility.isTypeVisible(accessEvaluator, referencingType, targetType, isReferencedFromTestMethod, true);
    }

    private static boolean isTypeVisible(final AccessEvaluator accessEvaluator, final TypeInfo referencingType, TypeInfo targetType, final boolean isReferencedFromTestMethod, final boolean isHiddenReferenceOkay) {
        boolean isTypeAccessible;
        if (targetType.getModifiers().has(AnnotationTypeInfos.PERM_GUARD)) {
            AnnotationParameter permGuardParameter = targetType.getModifiers().get(AnnotationTypeInfos.PERM_GUARD).getParameter("value");
            if (!accessEvaluator.hasPermissionForPermGuard(referencingType.getNamespace(), permGuardParameter.getStringValue())) {
                return false;
            }
        }
        if (targetType.getBasicType() == BasicType.VF_COMPONENT && Visibility.isTopLevelTriggerOrAnonymous(referencingType)) {
            return false;
        }
        if (!Namespace.equals(referencingType, targetType) && !accessEvaluator.isAccessibleOrTrustedNamespace(targetType.getNamespace())) {
            return false;
        }
        if (!PackagingVersionVisibility.isPackagingVersionVisible(referencingType, targetType, targetType.getCodeUnitDetails().getLoc())) {
            return false;
        }
        AccessType accessType = AccessType.get(targetType.getModifiers(), false);
        switch (accessType) {
            case GLOBAL: {
                isTypeAccessible = true;
                break;
            }
            case PUBLIC: {
                isTypeAccessible = referencingType.getNamespace().equals(targetType.getNamespace());
                break;
            }
            case PRIVATE: 
            case DEFAULT: {
                isTypeAccessible = TypeInfoEquivalence.isEquivalent(TypeInfoUtil.getTopLevel(referencingType), TypeInfoUtil.getTopLevel(targetType));
                break;
            }
            case HIDDEN: {
                isTypeAccessible = isHiddenReferenceOkay;
                break;
            }
            default: {
                throw new IllegalArgumentException("Referencing type contains unexpected modifier: " + accessType.toString() + ". Type: " + targetType.getApexName());
            }
        }
        boolean areTypeArgumentsAccessible = targetType.accept(new TypeInfoVisitor.Default<Boolean>(){

            @Override
            public Boolean _default(TypeInfo type) {
                return true;
            }

            @Override
            public Boolean visit(GenericTypeInfo type) {
                return MoreIterables.ensureNone(type.getTypeArguments(), argumentType -> !Visibility.isTypeVisible(accessEvaluator, referencingType, argumentType, isReferencedFromTestMethod, isHiddenReferenceOkay));
            }
        });
        return (isTypeAccessible || Visibility.isTypeTestVisible(referencingType, targetType, isReferencedFromTestMethod)) && areTypeArgumentsAccessible;
    }

    private static boolean isTopLevelTriggerOrAnonymous(TypeInfo referencingType) {
        TypeInfo topLevelType = TypeInfoUtil.getTopLevel(referencingType);
        return topLevelType.getUnitType() == UnitType.TRIGGER || topLevelType.getUnitType() == UnitType.ANONYMOUS;
    }

    public static boolean isTypeSfdcOnlyVisibleFromCurrentType(SymbolResolver symbols, TypeInfo referencingType, TypeInfo targetType) {
        return !targetType.getModifiers().has(AnnotationTypeInfos.SFDC_ONLY) || Visibility.isApexTrusted(symbols.getAccessEvaluator(), referencingType);
    }

    public static boolean isMemberVisible(TypeInfo referencingType, Member member, boolean isReferencedFromTestMethod) {
        return Visibility.isMemberVisible(referencingType, member, isReferencedFromTestMethod, CheckType.NO_CHECK);
    }

    public static boolean isMemberVisible(TypeInfo referencingType, Member member, boolean isReferencedFromTestMethod, CheckType checkType) {
        ModifierGroup targetModifiers = member.accept(new MemberModifiersFinder(checkType));
        boolean isMemberVisible = Visibility.isMemberVisibleNoTestCheck(referencingType, member.getDefiningType(), targetModifiers, member.getMemberType() == Member.Type.PROPERTY);
        if (!PackagingVersionVisibility.isPackagingVersionVisible(referencingType, member.getDefiningType(), member.getLoc())) {
            isMemberVisible = false;
        }
        return isMemberVisible || Visibility.isMemberTestVisible(referencingType, member.getDefiningType(), member.getModifiers(), isReferencedFromTestMethod);
    }

    private static boolean isTypeTestVisible(TypeInfo referencingType, TypeInfo targetType, boolean isReferencedFromTestMethod) {
        return Visibility.isTestVisibleWorker(referencingType, targetType.getNamespace(), targetType.getModifiers(), isReferencedFromTestMethod);
    }

    private static boolean isMemberTestVisible(TypeInfo referencingType, TypeInfo memberDefiningType, ModifierGroup memberModifiers, boolean isReferencedFromTestMethod) {
        return Visibility.isTestVisibleWorker(referencingType, memberDefiningType.getNamespace(), memberModifiers, isReferencedFromTestMethod);
    }

    private static boolean isTestVisibleWorker(TypeInfo referencingType, Namespace targetNamespace, ModifierGroup targetObjectModifiers, boolean isReferencedFromTestMethod) {
        return referencingType.getNamespace().equals(targetNamespace) && targetObjectModifiers.has(AnnotationTypeInfos.TEST_VISIBLE) && (TypeInfoUtil.isTestClass(referencingType) || isReferencedFromTestMethod);
    }

    public static boolean isMemberVisibleNoTestCheck(TypeInfo referencingType, TypeInfo memberDefiningType, ModifierGroup targetModifiers) {
        return Visibility.isMemberVisibleNoTestCheck(referencingType, memberDefiningType, targetModifiers, false);
    }

    public static boolean isMemberVisibleNoTestCheck(TypeInfo referencingType, TypeInfo memberDefiningType, ModifierGroup targetModifiers, boolean isProperty) {
        AccessType accessType = AccessType.get(targetModifiers, isProperty);
        switch (accessType) {
            case GLOBAL: {
                return true;
            }
            case PUBLIC: {
                return referencingType.getNamespace().equalsGlobal(memberDefiningType.getNamespace());
            }
            case PROTECTED: {
                return referencingType.getNamespace().equalsGlobal(memberDefiningType.getNamespace()) && (Visibility.isRawEquivalent(TypeInfoUtil.getTopLevel(referencingType), memberDefiningType) || TypeInfoUtil.isAncestor(referencingType, memberDefiningType));
            }
            case PRIVATE: 
            case DEFAULT: {
                return Visibility.isRawEquivalent(TypeInfoUtil.getTopLevel(referencingType), TypeInfoUtil.getTopLevel(memberDefiningType));
            }
            case NOOP: {
                return false;
            }
            case HIDDEN: {
                return false;
            }
        }
        return false;
    }

    private static boolean isRawEquivalent(TypeInfo referencingType, TypeInfo memberDefiningType) {
        return TypeInfoEquivalence.isEquivalent(GenericTypeInfoUtil.getRootType(referencingType), GenericTypeInfoUtil.getRootType(memberDefiningType));
    }

    public static boolean isMemberSfdcOnlyVisible(AccessEvaluator accessEvaluator, TypeInfo referencingType, TypeInfo memberDefiningType, ModifierGroup memberModifiers, JavaSfdcOnlyAnnotation methodJavaSfdcOnlyAnnotation) {
        if (methodJavaSfdcOnlyAnnotation != null) {
            if (methodJavaSfdcOnlyAnnotation.isAllowOnlyInTesting() && !accessEvaluator.isRunningTests()) {
                return false;
            }
            if (methodJavaSfdcOnlyAnnotation.isAllowOnlyInRealTesting() && !accessEvaluator.isReallyRunningTests()) {
                return false;
            }
            if (accessEvaluator.isSfdc()) {
                return true;
            }
            if (methodJavaSfdcOnlyAnnotation.isAllowTesting() && accessEvaluator.isRunningTests()) {
                return true;
            }
            if (methodJavaSfdcOnlyAnnotation.isAllowInternalSfdc() && accessEvaluator.hasInternalSfdc()) {
                return true;
            }
            if (methodJavaSfdcOnlyAnnotation.isAllowTrustedApplications() && accessEvaluator.isTrustedApplication()) {
                return true;
            }
            if (methodJavaSfdcOnlyAnnotation.isAllowInApexFiles() && accessEvaluator.isAccessibleSystemNamespace(referencingType.getNamespace())) {
                return true;
            }
            return methodJavaSfdcOnlyAnnotation.isAllowPrivate() && accessEvaluator.hasPrivateApi() && accessEvaluator.hasLocalizedTranslation();
        }
        if (memberDefiningType.getModifiers().has(AnnotationTypeInfos.SFDC_ONLY) && !Visibility.isApexTrusted(accessEvaluator, referencingType) && !StandardAnnotationsUtil.isSfdcOnlyExplicitlyDisabled(memberModifiers)) {
            return false;
        }
        return !StandardAnnotationsUtil.isSfdcOnlyEnabled(memberModifiers) || Visibility.isApexTrusted(accessEvaluator, referencingType);
    }

    public static boolean isMethodPrivateApiVisible(AccessEvaluator accessEvaluator, ModifierGroup methodModifiers, ModifierGroup methodDefiningTypeModifiers) {
        return !methodModifiers.has(AnnotationTypeInfos.PRIVATE_API) && !methodDefiningTypeModifiers.has(AnnotationTypeInfos.PRIVATE_API) || accessEvaluator.hasPermission(PlaceholderOrgPerm.PRIVATE_API);
    }

    public static boolean isMethodAllowCertifiedApexVisible(AccessEvaluator accessEvaluator, ModifierGroup methodModifiers, ModifierGroup methodDefiningTypeModifiers) {
        return !methodModifiers.has(AnnotationTypeInfos.ALLOW_CERTIFIED_APEX) && !methodDefiningTypeModifiers.has(AnnotationTypeInfos.ALLOW_CERTIFIED_APEX) || accessEvaluator.isTrustedApplication();
    }

    static boolean isApexTrusted(AccessEvaluator accessEvaluator, TypeInfo type) {
        return type.getCodeUnitDetails().isTrusted() || accessEvaluator.hasInternalSfdc();
    }

    public static class ModifiersFinder
    extends VariableVisitor.Default<ModifierGroup> {
        private final CheckType checkType;

        public ModifiersFinder(CheckType checkType) {
            this.checkType = checkType;
        }

        protected ModifierGroup visitProperty(PropertyInfo info) {
            switch (this.checkType) {
                case CALLER_READ: {
                    return info.getProperty().getGetter().getModifiers();
                }
                case CALLER_WRITE: {
                    return info.getProperty().getSetter().getModifiers();
                }
                case NO_CHECK: {
                    return ModifierGroups.GLOBAL;
                }
            }
            throw new UnexpectedCodePathException();
        }

        @Override
        public ModifierGroup _default(Variable info, VariableVisitor.Context context) {
            return info.getModifiers();
        }

        @Override
        public ModifierGroup visit(StandardPropertyInfo info, VariableVisitor.Context context) {
            return this.visitProperty(info);
        }

        @Override
        public ModifierGroup visit(TriggerPropertyInfo info, VariableVisitor.Context context) {
            return this.visitProperty(info);
        }

        @Override
        public ModifierGroup visit(DynamicFieldInfo info, VariableVisitor.Context context) {
            return info.getModifiers();
        }
    }

    public static class MemberModifiersFinder
    implements MemberVisitor<ModifierGroup> {
        private final CheckType checkType;

        public MemberModifiersFinder(CheckType checkType) {
            this.checkType = checkType;
        }

        @Override
        public ModifierGroup visit(Variable variable) {
            return variable.accept(new ModifiersFinder(this.checkType), null);
        }

        @Override
        public ModifierGroup visit(MethodInfo info) {
            return info.getModifiers();
        }
    }

    public static enum AccessType {
        GLOBAL,
        PUBLIC,
        PROTECTED,
        PRIVATE,
        DEFAULT,
        HIDDEN,
        NOOP;

        public static final AccessType PROPERTY_DEFAULT;
        public static final AccessType NON_PROPERTY_DEFAULT;

        public static AccessType get(ModifierGroup modifiers, boolean isProperty) {
            return AccessType.get(modifiers, isProperty ? PROPERTY_DEFAULT : NON_PROPERTY_DEFAULT);
        }

        private static AccessType get(ModifierGroup modifiers, AccessType defaultValue) {
            if (modifiers.has(ModifierTypeInfos.HIDDEN)) {
                return HIDDEN;
            }
            if (modifiers.has(ModifierTypeInfos.GLOBAL)) {
                return GLOBAL;
            }
            if (modifiers.has(ModifierTypeInfos.PUBLIC)) {
                return PUBLIC;
            }
            if (modifiers.has(ModifierTypeInfos.PROTECTED)) {
                return PROTECTED;
            }
            if (modifiers.has(ModifierTypeInfos.PRIVATE)) {
                return PRIVATE;
            }
            return defaultValue;
        }

        static {
            PROPERTY_DEFAULT = NOOP;
            NON_PROPERTY_DEFAULT = DEFAULT;
        }
    }

    public static enum CheckType {
        CALLER_READ,
        CALLER_WRITE,
        EXTERNAL_READ,
        EXTERNAL_WRITE,
        NO_CHECK;

    }
}

